"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
/** @format */
var sdk_1 = require("../../sdk");
var constants_1 = require("../../constants");
var utils_1 = require("../../utils");
/**
 *  限制单位时间接口请求次数
 *
 * @export
 * @param {number} limitCount 限制次数
 * @param {number} limitTime 限制的单位时间
 * @return {*}
 */
function requestCountLimit(limitCount, limitTime) {
    return function (target, name, descriptor) {
        var method = descriptor.value;
        descriptor.value = function () {
            var _a, _b, _c;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return __awaiter(this, void 0, void 0, function () {
                var recordTableName, context, _d, baseInfos, _e, services, _f, preCheckData, activityId, openId, handler, now, data, handlerRecord, error_1;
                return __generator(this, function (_g) {
                    switch (_g.label) {
                        case 0:
                            recordTableName = 'c_test';
                            context = args[0], _d = args[1], baseInfos = _d === void 0 ? {} : _d, _e = args[2], services = _e === void 0 ? [] : _e, _f = args[3], preCheckData = _f === void 0 ? {} : _f;
                            activityId = context.data.activityId;
                            openId = context.openId;
                            handler = (_c = (_b = (_a = context === null || context === void 0 ? void 0 : context.cloud) === null || _a === void 0 ? void 0 : _a.dataspace) === null || _b === void 0 ? void 0 : _b.context) === null || _c === void 0 ? void 0 : _c.handler;
                            now = Date.now();
                            _g.label = 1;
                        case 1:
                            _g.trys.push([1, 9, , 10]);
                            return [4 /*yield*/, context.cloud.dataspace.executeSql("SELECT gmt_modified, expired_time, count FROM " + recordTableName + " where activity_id = ? and open_id = ? and handler = ?", [activityId, openId, handler])];
                        case 2:
                            data = _g.sent();
                            handlerRecord = data === null || data === void 0 ? void 0 : data[0];
                            if (!!handlerRecord) return [3 /*break*/, 3];
                            context.cloud.dataspace.executeSql("insert into " + recordTableName + "(activity_id,open_id,handler,count, expired_time) values(?,?)", [activityId, openId, handler, 1, now + limitTime]);
                            return [3 /*break*/, 8];
                        case 3:
                            if (!(now <= handlerRecord.expired_time)) return [3 /*break*/, 6];
                            if (!((handlerRecord === null || handlerRecord === void 0 ? void 0 : handlerRecord.count) < limitCount)) return [3 /*break*/, 5];
                            return [4 /*yield*/, context.cloud.dataspace.executeSql("update " + recordTableName + " set count = ? where activity_id = ? and open_id = ? and handler = ?", [(handlerRecord === null || handlerRecord === void 0 ? void 0 : handlerRecord.count) + 1, activityId, openId, handler])];
                        case 4:
                            _g.sent();
                            return [3 /*break*/, 6];
                        case 5: return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '请求过于频繁，请稍后再试~')];
                        case 6:
                            if (!(now > handlerRecord.expired_time)) return [3 /*break*/, 8];
                            return [4 /*yield*/, context.cloud.dataspace.executeSql("update " + recordTableName + " set count = ? expired_time = ? where activity_id = ? and open_id = ? and handler = ?", [1, now + limitTime, activityId, openId, handler])];
                        case 7:
                            _g.sent();
                            _g.label = 8;
                        case 8: return [3 /*break*/, 10];
                        case 9:
                            error_1 = _g.sent();
                            console.log('error', error_1);
                            utils_1.recordErrorLog(context, baseInfos, error_1.toString(), error_1.stack);
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR)];
                        case 10: return [2 /*return*/, method.apply(target, [context, baseInfos, services, preCheckData])];
                    }
                });
            });
        };
    };
}
exports.default = requestCountLimit;
//# sourceMappingURL=requestCountLimit.js.map