"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_1 = require("lodash");
var logger_1 = require("../../utils/common/logger");
var sdk_1 = require("../../sdk");
var errorCode_1 = require("../../errorCode");
var format_1 = require("../../utils/common/format");
var mongodb_1 = require("../../utils/common/mongodb");
var db_1 = require("../../db");
// 前置更新
function preUpdate(checks) {
    return function (target, name, descriptor) {
        var method = descriptor.value;
        descriptor.value = function () {
            var _a, _b;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return __awaiter(this, void 0, void 0, function () {
                var context, _c, otherArgs, _d, services, _e, preCheckData, totalUpdateProjection, i, checkFn, result, updateResult, error_1;
                return __generator(this, function (_f) {
                    switch (_f.label) {
                        case 0:
                            context = args[0], _c = args[1], otherArgs = _c === void 0 ? {} : _c, _d = args[2], services = _d === void 0 ? [] : _d, _e = args[3], preCheckData = _e === void 0 ? {} : _e;
                            totalUpdateProjection = {};
                            i = 0;
                            _f.label = 1;
                        case 1:
                            if (!(i < checks.length)) return [3 /*break*/, 4];
                            checkFn = checks[i];
                            return [4 /*yield*/, checkFn.apply(target, [context, __assign({}, otherArgs), services])];
                        case 2:
                            result = _f.sent();
                            result = result || {};
                            // 校验报错
                            if (((_a = result) === null || _a === void 0 ? void 0 : _a.success) === false && ((_b = result) === null || _b === void 0 ? void 0 : _b.code)) {
                                return [2 /*return*/, result];
                            }
                            totalUpdateProjection = lodash_1.merge({}, totalUpdateProjection, result);
                            otherArgs = __assign({}, otherArgs);
                            _f.label = 3;
                        case 3:
                            i++;
                            return [3 /*break*/, 1];
                        case 4:
                            _f.trys.push([4, 6, , 7]);
                            return [4 /*yield*/, preUpdateUser(context, otherArgs.userInfo, totalUpdateProjection)];
                        case 5:
                            updateResult = _f.sent();
                            if (!updateResult)
                                return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.SYSTEM_ERROR, '用户信息更新失败')
                                    // 避免再次查询
                                ];
                            // 避免再次查询
                            otherArgs.userInfo = format_1.formatUpdatedDataByProjection(otherArgs.userInfo, totalUpdateProjection);
                            return [3 /*break*/, 7];
                        case 6:
                            error_1 = _f.sent();
                            console.log(error_1, 'preUpdateUser-error');
                            logger_1.recordErrorLog(context, otherArgs, error_1.toString(), error_1.stack);
                            return [2 /*return*/, sdk_1.resultsModel.error(errorCode_1.CODE_TYPES.SYSTEM_ERROR)];
                        case 7: return [2 /*return*/, method.apply(target, [context, __assign({}, otherArgs), services, preCheckData])];
                    }
                });
            });
        };
    };
}
exports.default = preUpdate;
function preUpdateUser(context, userInfo, updateProjection) {
    return __awaiter(this, void 0, void 0, function () {
        var query;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    // 删除空的操作
                    if (lodash_1.isEmpty(updateProjection === null || updateProjection === void 0 ? void 0 : updateProjection.$inc)) {
                        delete updateProjection.$inc;
                    }
                    if (lodash_1.isEmpty(updateProjection === null || updateProjection === void 0 ? void 0 : updateProjection.$set)) {
                        delete updateProjection.$set;
                    }
                    if (lodash_1.isEmpty(updateProjection === null || updateProjection === void 0 ? void 0 : updateProjection.$push)) {
                        delete updateProjection.$push;
                    }
                    if (lodash_1.isEmpty(updateProjection === null || updateProjection === void 0 ? void 0 : updateProjection.$where)) {
                        delete updateProjection.$where;
                    }
                    if (lodash_1.isEmpty(updateProjection))
                        return [2 /*return*/, true];
                    query = (updateProjection === null || updateProjection === void 0 ? void 0 : updateProjection.$where) ? {
                        _id: userInfo === null || userInfo === void 0 ? void 0 : userInfo._id,
                        $where: updateProjection === null || updateProjection === void 0 ? void 0 : updateProjection.$where
                    }
                        : {
                            _id: userInfo === null || userInfo === void 0 ? void 0 : userInfo._id
                        };
                    if (updateProjection === null || updateProjection === void 0 ? void 0 : updateProjection.$where) {
                        updateProjection === null || updateProjection === void 0 ? true : delete updateProjection.$where;
                    }
                    return [4 /*yield*/, mongodb_1.dbUpdate(context, db_1.USER_DB_NAME, query, format_1.formatUpdateUserProjection(updateProjection))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
//# sourceMappingURL=preUpdate.js.map