"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
/** @format */
var sdk_1 = require("../../sdk");
var constants_1 = require("../../constants");
var utils_1 = require("../../utils");
/**
 *  检查接口参数
 *
 *  @checkParams(['activityId', 'itemId?'])
 *
 *  itemId?  问号结尾为可选参数 不做校验
 *
 * @export
 * @param {string[]} params 参数列表
 * @return {*}
 */
function checkParams(params) {
    return function (target, name, descriptor) {
        var method = descriptor.value;
        descriptor.value = function () {
            var _a;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var context = args[0], _b = args[1], otherArgs = _b === void 0 ? {} : _b, _c = args[2], services = _c === void 0 ? [] : _c, _d = args[3], preCheckData = _d === void 0 ? {} : _d;
            var dataKeys = Object.keys(context.data);
            var requiredParams = params.filter(function (v) { return !v.endsWith('?'); });
            for (var i = 0; i < requiredParams.length; i++) {
                var param = requiredParams[i];
                if (!dataKeys.includes(param) || ((_a = context.data) === null || _a === void 0 ? void 0 : _a[param]) === '') {
                    utils_1.logFn(context);
                    return sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u7F3A\u5C11" + param + "\u53C2\u6570");
                }
            }
            return method.apply(target, [context, __assign({}, otherArgs), services, preCheckData]);
        };
    };
}
exports.default = checkParams;
//# sourceMappingURL=checkParams.js.map