/** @format */
import { CommonUserService } from '../service/common';
interface IRankList {
    userNick: string;
    avatar: string;
    score: any;
    rank: number;
}
export interface IRankResult {
    rank: number;
    userNick: string;
    avatar: string;
    score: number;
    list: IRankList[];
}
export default class User {
    /**
     *  获取会员信息
     */
    getVipInfo(context: IContext<IParams>, { activityInfo }: IControllerInfos, [userService]: [CommonUserService]): Promise<IResult<IVipInfo>>;
    /**
     *  获取排行榜
     */
    getRankList(context: IContext<IParams>, { userInfo }: IControllerInfos, [userService]: [CommonUserService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        list: {
            [x: string]: any;
            avatar: string;
            userNick: string;
            rank: number;
        }[];
        rank: number;
        userNick: string;
        avatar: string;
    }, true>>;
}
export {};
