/** @format */
import { CommonTaskService, CommonBaseService } from '../service/common';
import { ITaskInfo } from '../service/common/task.service';
export default class Task {
    /**
     * 任务列表
     */
    getTaskList(context: IContext<IParams>, { userInfo, activityInfo }: IControllerInfos, [taskService]: [CommonTaskService]): Promise<IResult<{
        list: ITaskInfo[];
    }>>;
    /**
     * 完成任务
     *
     * 商品相关任务 需要传itemId参数
     * 积分兑换任务 需要传credits参数
     */
    doCompleteTask(context: IContext<IParams>, { userInfo, activityInfo }: IControllerInfos, [taskService]: [CommonTaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<any, false> | import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        ok: number;
    }, true>>;
    /**
     * 领取任务奖励
     * 领取的奖励增加的key值  如: gameTimes  前端传入
     */
    receiveTaskRewards(context: IContext<IParams>, { userInfo }: IControllerInfos, [taskService]: [CommonTaskService]): Promise<IResult<{
        rewards: number;
    }>>;
    /**
     * 获取收藏商品列表
     */
    getCollectGoodsList(context: IContext<IParams>, { session, userInfo }: IControllerInfos, [commonBaseService, commonTaskService]: [CommonBaseService, CommonTaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        collected: boolean;
        itemId: string;
        name: string;
        price: string;
        url: string;
        image: string;
        desc: string;
    }[], true>>;
}
