/** @format */
import { CommonUserService, CommonAccessService } from '../service/common';
export default class LoginController {
    /**
     *  登录接口, 初始化/更新用户信息
     *
     *  updateFirstLoginToday 当天第一次登陆的操作 如增加 3次游戏次数 gameTimes
     *
     *  updateFirstLoginToday({ $inc: { gameTime: 3}})
     */
    login(context: IContext<IParams>, { userInfo, activityInfo, vipInfo }: IControllerInfos, [userService, accessService]: [CommonUserService, CommonAccessService]): Promise<IResult<{
        openId: string;
        firstLoginToday: boolean;
        newUser: boolean;
    }>>;
}
