/** @format */
import { CommonUserService, CommonGameService } from '../service/common';
export interface ISumitGameControllerInfos extends IControllerInfos {
    joinInfo: IJoinRecord;
}
export default class Game {
    /**
     *  获取游戏信息
     *
     *  needKeys 根据需求自取字段  格式： { gameTimes: 1 }
     */
    getGameInfo(context: IContext<IParams>, { userInfo, activityInfo }: IControllerInfos, [userService]: [CommonUserService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        gameTimes?: number;
        maxScore?: number;
        totalScore?: number;
        updateScoreTime?: number;
        _id?: string;
        id?: string;
        activityId: string;
        avatar: string;
        userNick: string;
        openId: string;
        createTime: number;
        updateTime: number;
        createDay?: string;
        inviteId?: string;
        member?: IMemberInfo;
        follow?: IFollowInfo;
        remainTimes?: IRemainTimesInfo;
        taskInfo?: object;
        login?: object;
    }, true>>;
    startGame(context: IContext<IParams>, { userInfo, activityInfo }: IControllerInfos, [gameService]: [CommonGameService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        id: string;
    }, true>>;
    submitGame(context: IContext<IParams>, { userInfo }: ISumitGameControllerInfos, [gameService]: [CommonGameService], { joinInfo }: IPreCheckData): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        score: number;
        maxScore: number;
        totalScore: number;
        gameTimes: number;
        duration: number;
        avatar: string;
        userNick: string;
        rank: number;
    }, true>>;
    getMyRankPrize(context: IContext<IParams>, { userInfo, activityInfo }: IControllerInfos, [gameService]: [CommonGameService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{}, true>>;
}
