import { CommonUserService } from '../../service/common';
export default class UserController {
    /**
     *  获取会员信息
     */
    getVipInfo(context: IContext<IParams>, { activityInfo, userInfo }: IControllerInfos, [commonUserService]: [CommonUserService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        isVip: boolean;
        url?: string;
    }, true>>;
    /**
     *  获取排行榜
     */
    getRankList(context: IContext<IParams>, { activityInfo, userInfo }: IControllerInfos, [commonUserService]: [CommonUserService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        list: {
            [x: string]: any;
            avatar: string;
            userNick: string;
            rank: number;
        }[];
        rank: number;
        userNick: string;
        avatar: string;
    }, true>>;
}
