import { CommonTaskService, CommonBaseService } from '../../service/common';
export default class TaskController {
    /**
     *  任务列表
     */
    getTaskList(context: IContext<IParams>, { activityInfo, userInfo, vipInfo }: IControllerInfos, [commonTaskService]: [CommonTaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        list: import("../../service/common/task.service").ITaskInfo[];
    }, true>>;
    /**
     *  完成任务
     */
    doCompleteTask(context: IContext<IParams>, { activityInfo, userInfo, session }: IControllerInfos, [commonTaskService]: [CommonTaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<any, false>>;
    /**
     *  领取任务奖励
     */
    receiveTaskRewards(context: IContext<IParams>, { activityInfo, userInfo }: IControllerInfos, [commonTaskService]: [CommonTaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        rewards: number;
    }, true>>;
    /**
     *  获取收藏商品列表
     */
    getCollectGoodsList(context: IContext<IParams>, { activityInfo, userInfo, session }: IControllerInfos, [commonBaseService, commonTaskService]: [CommonBaseService, CommonTaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        [x: number]: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        };
        length: number;
        toString(): string;
        toLocaleString(): string;
        pop(): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        };
        push(...items: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]): number;
        concat(...items: ConcatArray<{
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }>[]): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        concat(...items: ({
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        } | ConcatArray<{
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }>)[]): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        join(separator?: string): string;
        reverse(): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        shift(): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        };
        slice(start?: number, end?: number): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        sort(compareFn?: (a: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, b: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }) => number): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        splice(start: number, deleteCount?: number): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        splice(start: number, deleteCount: number, ...items: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        unshift(...items: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]): number;
        indexOf(searchElement: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, fromIndex?: number): number;
        lastIndexOf(searchElement: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, fromIndex?: number): number;
        every<S extends {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }>(predicate: (value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => value is S, thisArg?: any): this is S[];
        every(predicate: (value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => unknown, thisArg?: any): boolean;
        some(predicate: (value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => unknown, thisArg?: any): boolean;
        forEach(callbackfn: (value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => void, thisArg?: any): void;
        map<U>(callbackfn: (value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => U, thisArg?: any): U[];
        filter<S_1 extends {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }>(predicate: (value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => value is S_1, thisArg?: any): S_1[];
        filter(predicate: (value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => unknown, thisArg?: any): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        reduce(callbackfn: (previousValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentIndex: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        };
        reduce(callbackfn: (previousValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentIndex: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, initialValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        };
        reduce<U_1>(callbackfn: (previousValue: U_1, currentValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentIndex: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => U_1, initialValue: U_1): U_1;
        reduceRight(callbackfn: (previousValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentIndex: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        };
        reduceRight(callbackfn: (previousValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentIndex: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, initialValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        };
        reduceRight<U_2>(callbackfn: (previousValue: U_2, currentValue: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, currentIndex: number, array: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => U_2, initialValue: U_2): U_2;
        find<S_2 extends {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }>(predicate: (this: void, value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, obj: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => value is S_2, thisArg?: any): S_2;
        find(predicate: (value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, obj: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => unknown, thisArg?: any): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        };
        findIndex(predicate: (value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, index: number, obj: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[]) => unknown, thisArg?: any): number;
        fill(value: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, start?: number, end?: number): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        copyWithin(target: number, start: number, end?: number): {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }[];
        [Symbol.iterator](): IterableIterator<{
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }>;
        entries(): IterableIterator<[number, {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }]>;
        keys(): IterableIterator<number>;
        values(): IterableIterator<{
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }>;
        [Symbol.unscopables](): {
            copyWithin: boolean;
            entries: boolean;
            fill: boolean;
            find: boolean;
            findIndex: boolean;
            keys: boolean;
            values: boolean;
        };
        includes(searchElement: {
            collected: boolean;
            itemId: string;
            name: string;
            price: string;
            url: string;
            image: string;
            desc: string;
        }, fromIndex?: number): boolean;
    }, true>>;
}
