import { CommonAwardsService } from '../../service/common';
export default class AwardsController {
    /**
     *  我的奖品列表
     */
    getMyPrizeList(context: IContext<IParams>, { activityInfo, userInfo }: IControllerInfos, [commonAwardsService]: [CommonAwardsService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        expiredTime: number;
        list: IAwards[];
    }, true>>;
    /**
     *  领取实物
     */
    receiveObjectPrize(context: IContext<IParams>, { activityInfo, userInfo }: IControllerInfos, [commonAwardsService]: [CommonAwardsService], { awardInfo }: IPreCheckData): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<any, false>>;
    /**
     *  领取权益
     */
    receiveEnamePrize(context: IContext<IParams>, { activityInfo, userInfo, session }: IControllerInfos, [commonAwardsService]: [CommonAwardsService], { awardInfo }: IPreCheckData): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<any, false>>;
    /**
     *  概率抽奖
     */
    drawLotteryPrize(context: IContext<IParams>, { activityInfo, userInfo, session }: IControllerInfos, [commonAwardsService]: [CommonAwardsService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        id: string;
        type: number;
        name: string;
        image: string;
    }, true>>;
}
