/** @format */
import { CommonAwardsService } from '../service/common';
export interface IReceivePrizeControllerInfos extends IControllerInfos {
    awardInfo: IAwards;
}
export default class AwardsController {
    /**
     *  我的奖品列表
     */
    getMyPrizeList(context: IContext<IParams>, { activityInfo }: IControllerInfos, [awardSer]: [CommonAwardsService]): Promise<IResult<{
        list: IAwards[];
    }>>;
    /**
     *  领取实物
     */
    receiveObjectPrize(context: IContext<IParams>, { activityInfo }: IReceivePrizeControllerInfos, [awardSer]: [CommonAwardsService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<any, false> | import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        province: any;
        city: any;
        area: any;
        streetName: any;
        addressDetail: any;
        id: any;
        name: any;
        phone: any;
    }, true>>;
    /**
     *  权益重新领取
     */
    receiveEnamePrize(context: IContext<IParams>, { session }: IReceivePrizeControllerInfos, [awardSer]: [CommonAwardsService], { awardInfo }: IPreCheckData): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<any, false> | import("taobao-mini-sdk/lib/utils/resultmodel").Result<IAwards, true>>;
    /**
     *  概率抽奖
     */
    drawLotteryPrize(context: IContext<IParams>, { userInfo }: IControllerInfos, [awardSer]: [CommonAwardsService]): Promise<IResult<{
        id?: string;
        type: number;
        name: string;
        image?: string;
    }>>;
}
