/** @format */

import { CODE_TYPES } from './../constants'
import { services, paramsCheck } from '../decorator'
import { resultsModel } from '../sdk'
import { ActivityconfigService } from '../service'

export default class ActivityController {
  /**
   *  活动基本信息
   */
  @services([ActivityconfigService])
  async getActivityList(context: Context, {}, [activityconfigService]: [ActivityconfigService]) {
    const { openId } = context

    let result = await activityconfigService.getActivityListByOpenId(openId, context.data)
    if (result) {
      result.list = result.list.map((item: { _id: string }) => {
        return {
          ...item,
          activityId: item._id
        }
      })
      return resultsModel.success(result)
    }
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '查询活动列表失败')
  }

  /**
   *  活动详情
   */
  @paramsCheck(['activityId'])
  @services([ActivityconfigService])
  async getActivityDetail(context: Context, {}, [activityconfigService]: [ActivityconfigService]) {
    const { activityId } = context.data

    let result = await activityconfigService.getActivityInfoByActivityId(activityId)
    if (!result) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '当前活动不存在')

    const { prizeConfig, baseConfig } = result || {}

    // 奖品配置统一存在b_prize_config表中, 接口返回时根据需求重新组装
    const prizes = activityconfigService.formatPrizeConfig(prizeConfig)

    let activityInfo = {
      activityId,
      ...baseConfig,
      ...prizes
    }
    return resultsModel.success(activityInfo)
  }

  /**
   *  删除活动
   */
  @paramsCheck(['activityId'])
  @services([ActivityconfigService])
  async delActivity(context: Context, {}, [activityconfigService]: [ActivityconfigService]) {
    const { activityId } = context.data

    let result = await activityconfigService.deleteActivityByActivityId(activityId)
    const deleteSuccess: boolean = result === 0 || result
    if (deleteSuccess) {
      return resultsModel.success(true)
    } else {
      return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '删除活动失败')
    }
  }
}
