"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.paramsCheck = void 0;
/** @format */
var sdk_1 = require("../sdk");
var constants_1 = require("../constants");
exports.paramsCheck = function (params) {
    return function (target, name, descriptor) {
        var method = descriptor.value;
        descriptor.value = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var context = args[0], _a = args[1], otherArgs = _a === void 0 ? {} : _a;
            var dataKeys = Object.keys(context.data);
            for (var i = 0; i < params.length; i++) {
                var param = params[i];
                if (!dataKeys.includes(param))
                    return sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u7F3A\u5C11" + param + "\u53C2\u6570");
            }
            return method.apply(target, [context, __assign({}, otherArgs)]);
        };
    };
};
//# sourceMappingURL=check.js.map