"use strict";
/** @format */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("./../constants");
var decorator_1 = require("../decorator");
var sdk_1 = require("../sdk");
var utils_1 = require("../utils");
var service_1 = require("../service");
var xlsx = require("node-xlsx");
//奖池类型
var prizePoolType = {
    '1': '排行榜奖励',
    '2': '兑换奖品',
    '3': '大转盘奖品',
    '4': '其他奖励'
};
//发货状态
var shipMsg = {
    '1': '未填地址',
    '2': '未发货',
    '3': '已发货'
};
var prizeKind = {
    '1': '优惠券',
    '2': '权益',
    '3': '实物'
};
var BaseController = /** @class */ (function () {
    function BaseController() {
    }
    /**
     *  活动中奖名单
     */
    BaseController.prototype.findWinnerInfoList = function (context, _a, _b) {
        var session = _a.session;
        var awardsService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var _c, activityId, _d, pageNo, _e, pageSize, awardslist, winnersObj, results;
            return __generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        _c = context.data, activityId = _c.activityId, _d = _c.pageNo, pageNo = _d === void 0 ? 1 : _d, _e = _c.pageSize, pageSize = _e === void 0 ? 500 : _e;
                        return [4 /*yield*/, awardsService.getAwardslistByActivityId(activityId, pageNo, pageSize)];
                    case 1:
                        awardslist = _f.sent();
                        console.log("awardslist: " + JSON.stringify(awardslist));
                        winnersObj = {};
                        awardslist.forEach(function (v) {
                            if (!winnersObj[v.rank]) {
                                winnersObj[v.rank] = [];
                            }
                            winnersObj[v.rank].push({
                                userNick: v.userNick,
                                id: v.openId
                            });
                        });
                        console.log("winnersObj: " + JSON.stringify(winnersObj));
                        results = [];
                        new Map(Object.entries(winnersObj)).forEach(function (v, index) {
                            results.push({
                                rank: index,
                                winnerDetailList: v
                            });
                        });
                        return [2 /*return*/, sdk_1.resultsModel.success(results)];
                }
            });
        });
    };
    /**
     *  导出活动中奖名单
     */
    BaseController.prototype.exportAwardsList = function (context, _a, _b) {
        var session = _a.session;
        var awardsService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var cloud, _c, activityId, title, pageNo, pageSize, awardslist, nowPageNoList, xlsxData, buffer, result;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        cloud = context.cloud;
                        _c = context.data, activityId = _c.activityId, title = _c.title;
                        pageNo = 1;
                        pageSize = 500;
                        awardslist = [];
                        _d.label = 1;
                    case 1:
                        if (!(awardslist.length >= (pageNo - 1) * 500)) return [3 /*break*/, 3];
                        return [4 /*yield*/, awardsService.getAwardslistByActivityId(activityId, pageNo, pageSize)];
                    case 2:
                        nowPageNoList = _d.sent();
                        awardslist = __spreadArrays(awardslist, nowPageNoList);
                        pageNo += 1;
                        return [3 /*break*/, 1];
                    case 3:
                        console.log("awardslist: " + JSON.stringify(awardslist));
                        xlsxData = [['序列', '名次', '昵称', '中奖名称']];
                        awardslist.forEach(function (v, index, arr) {
                            xlsxData.push([index + 1, v.rank, v.userNick, v.name]);
                        });
                        buffer = xlsx.build([
                            {
                                name: title + new Date().getTime(),
                                data: xlsxData
                            }
                        ]);
                        console.log("xlsxData: " + JSON.stringify(xlsxData));
                        return [4 /*yield*/, cloud.file.uploadFile({
                                fileContent: buffer,
                                fileName: title + new Date().getTime() + '.xlsx'
                            })
                            // result.url 需进行处理
                        ];
                    case 4:
                        result = _d.sent();
                        // result.url 需进行处理
                        if (result.url) {
                            result.url = result.url.replace('http', 'https').replace('-internal', '');
                        }
                        return [2 /*return*/, sdk_1.resultsModel.success(result)];
                }
            });
        });
    };
    BaseController.prototype.exportAwardsInfoBySearch = function (context, _a, _b) {
        var session = _a.session;
        var awardsService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var cloud, _c, activityId, title, prizeId, userNick, timeStart, timeEnd, shipStatus, prizeDataType, total, awardslist, pageSize0, pageNo, totalPage, i, awardMore, xlsxData_1, buffer, result, e_1;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        cloud = context.cloud;
                        _c = context.data, activityId = _c.activityId, title = _c.title, prizeId = _c.prizeId, userNick = _c.userId, timeStart = _c.timeStart, timeEnd = _c.timeEnd, shipStatus = _c.shipStatus, prizeDataType = _c.prizeDataType;
                        if (!activityId) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u7F3A\u5C11activityId")];
                        }
                        if (!title) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u7F3A\u5C11title")];
                        }
                        console.log('prizeId=====', prizeId);
                        if (!prizeId && !userNick && !timeStart && !timeEnd && !shipStatus && !prizeDataType) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u672A\u586B\u5199\u7B5B\u9009\u4FE1\u606F")];
                        }
                        console.log('activityId--1--', activityId, 'prizeId--1-', prizeId, 'userNick--1-', userNick, 'timeStart--1-', timeStart, 'timeEnd--1-', timeEnd);
                        return [4 /*yield*/, awardsService.getTotalObjectCount(activityId, prizeId, userNick, timeStart, timeEnd, shipStatus, prizeDataType)];
                    case 1:
                        total = _d.sent();
                        awardslist = [];
                        pageSize0 = 500;
                        pageNo = 1;
                        if (!(total > pageSize0)) return [3 /*break*/, 6];
                        totalPage = Math.ceil(total / pageSize0);
                        i = 1;
                        _d.label = 2;
                    case 2:
                        if (!(i <= totalPage)) return [3 /*break*/, 5];
                        pageNo = i;
                        return [4 /*yield*/, awardsService.getUserPrizeByActivityId(activityId, pageNo, pageSize0, prizeId, userNick, timeStart, timeEnd, shipStatus, prizeDataType)];
                    case 3:
                        awardMore = _d.sent();
                        awardslist = awardslist.concat(awardMore);
                        _d.label = 4;
                    case 4:
                        i++;
                        return [3 /*break*/, 2];
                    case 5: return [3 /*break*/, 8];
                    case 6: return [4 /*yield*/, awardsService.getUserPrizeByActivityId(activityId, pageNo, total, prizeId, userNick, timeStart, timeEnd, shipStatus, prizeDataType)];
                    case 7:
                        awardslist = _d.sent();
                        _d.label = 8;
                    case 8:
                        console.log("awardslist:\u300B\u300B\u300B " + JSON.stringify(awardslist) + "\u300A\u300A\u300A");
                        if (!(awardslist.length > 0)) return [3 /*break*/, 13];
                        xlsxData_1 = [
                            [
                                '序列',
                                '奖品编号',
                                '中奖时间',
                                '地址填写时间',
                                '用户昵称',
                                '奖品种类',
                                '奖品类型',
                                '中奖名称',
                                '收货人',
                                '手机号',
                                '省',
                                '市',
                                '区',
                                '详细地址',
                                '发货状态',
                                '物流公司',
                                '物流单号'
                            ]
                        ];
                        awardslist.forEach(function (v, index, arr) {
                            xlsxData_1.push([
                                index + 1,
                                v._id,
                                //中奖时间-填写地址时间
                                v.createTime ? utils_1.formatTime(new Date(v.createTime + constants_1.EIGHT_HOURS)) : '',
                                v.type == 1 ? '/' : v.receiveTime ? utils_1.formatTime(new Date(v.receiveTime + constants_1.EIGHT_HOURS)) : '未填',
                                v.userNick || '/',
                                prizePoolType[v.prizeDataType],
                                prizeKind[v.type],
                                v.name || '',
                                v.type == 1 ? '/' : v.receiveName || '',
                                v.type == 1 ? '/' : v.phone || '未填',
                                v.type == 1 ? '/' : v.province ? v.province : '未填',
                                v.type == 1 ? '/' : v.city ? v.city : '未填',
                                v.type == 1 ? '/' : v.area ? v.area : '未填',
                                v.type == 1 ? '/' : v.addressdetail ? v.addressdetail : '未填',
                                v.type == 1 ? '/' : shipMsg[v.shipStatus],
                                v.type == 1 ? '/' : v.shipCompany || '/',
                                v.type == 1 ? '/' : v.shipNum || '/'
                            ]);
                        });
                        buffer = xlsx.build([
                            {
                                name: title + new Date().getTime(),
                                data: xlsxData_1
                            }
                        ]);
                        _d.label = 9;
                    case 9:
                        _d.trys.push([9, 11, , 12]);
                        return [4 /*yield*/, cloud.file.uploadFile({
                                fileContent: buffer,
                                fileName: title + new Date().getTime() + '.xlsx'
                            })
                            // result.url 需进行处理
                        ];
                    case 10:
                        result = _d.sent();
                        // result.url 需进行处理
                        if (result.url) {
                            result.url = result.url.replace('http', 'https').replace('-internal', '');
                        }
                        return [2 /*return*/, sdk_1.resultsModel.success(result)];
                    case 11:
                        e_1 = _d.sent();
                        console.log('上传文件出错', e_1);
                        // 打印日志
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, "\u4E0A\u4F20\u6587\u4EF6\u9519\u8BEF")];
                    case 12: return [3 /*break*/, 14];
                    case 13: return [2 /*return*/, sdk_1.resultsModel.success(false)];
                    case 14: return [2 /*return*/];
                }
            });
        });
    };
    //筛选中奖名单
    BaseController.prototype.findWinnerInfoListBySearch = function (context, _a, _b) {
        var session = _a.session;
        var awardsService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var cloud, _c, activityId, title, pageNo, pageSize, prizeId, userNick, timeStart, timeEnd, shipStatus, prizeDataType, total, awardslist, totalPage, awardMore;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        cloud = context.cloud;
                        _c = context.data, activityId = _c.activityId, title = _c.title, pageNo = _c.pageNo, pageSize = _c.pageSize, prizeId = _c.prizeId, userNick = _c.userId, timeStart = _c.timeStart, timeEnd = _c.timeEnd, shipStatus = _c.shipStatus, prizeDataType = _c.prizeDataType;
                        console.log('data>>>>>', context.data);
                        if (!activityId) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u7F3A\u5C11activityId")];
                        }
                        if (!title) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u7F3A\u5C11title")];
                        }
                        console.log('prizeId=====', prizeId);
                        if (!prizeId && !userNick && !timeStart && !timeEnd && !shipStatus && !prizeDataType) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u672A\u586B\u5199\u7B5B\u9009\u4FE1\u606F")];
                        }
                        console.log('activityId----', activityId, 'prizeId---', prizeId, 'userNick---', userNick, 'timeStart---', timeStart, 'timeEnd---', timeEnd, shipStatus);
                        return [4 /*yield*/, awardsService.getTotalObjectCount(activityId, prizeId, userNick, timeStart, timeEnd, shipStatus, prizeDataType)];
                    case 1:
                        total = _d.sent();
                        console.log('totle=========', total);
                        awardslist = [];
                        if (!(total > 10)) return [3 /*break*/, 3];
                        totalPage = Math.ceil(total / pageSize);
                        return [4 /*yield*/, awardsService.getUserPrizeByActivityId(activityId, pageNo, pageSize, prizeId, userNick, timeStart, timeEnd, shipStatus, prizeDataType)
                            // console.list()
                        ];
                    case 2:
                        awardMore = _d.sent();
                        // console.list()
                        awardslist = awardslist.concat(awardMore);
                        return [3 /*break*/, 5];
                    case 3: return [4 /*yield*/, awardsService.getUserPrizeByActivityId(activityId, pageNo, pageSize, prizeId, userNick, timeStart, timeEnd, shipStatus, prizeDataType)];
                    case 4:
                        awardslist = _d.sent();
                        console.log('awardslist>>>>', awardslist);
                        _d.label = 5;
                    case 5:
                        console.log("awardslist:\u300B\u300B\u300B " + JSON.stringify(awardslist) + "\u300A\u300A\u300A");
                        awardslist.map(function (item) {
                            var ad = item.province + item.city + item.area + item.addressdetail, type0 = item.type;
                            item.prizeId = item._id;
                            item.createTime = utils_1.formatTime(new Date(item.createTime + constants_1.EIGHT_HOURS)) || '';
                            item.receiveTime = item.receiveTime ? utils_1.formatTime(new Date(item.receiveTime + constants_1.EIGHT_HOURS)) : '未填';
                            item.prizeDataType = prizePoolType[item.prizeDataType];
                            item.type = prizeKind[item.type];
                            item.receiveName = type0 == 3 ? item.receiveName || '未填' : '/';
                            item.phone = type0 == 3 ? item.phone || '未填' : '/';
                            item.address = type0 == 3 ? (item.province ? ad : '未填') : '/';
                            item.shipStatus = type0 == 3 ? shipMsg[item.shipStatus] : '/';
                            item.shipCompany = type0 == 3 ? item.shipCompany || '/' : '/';
                            item.shipNum = type0 == 3 ? item.shipNum || '/' : '/';
                        });
                        // console.log(`xlsxData: ${JSON.stringify(xlsxData)}`);
                        try {
                            return [2 /*return*/, sdk_1.resultsModel.success({ list: awardslist, total: total })];
                        }
                        catch (e) {
                            console.log('上传文件出错', e);
                            // 打印日志
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, "\u67E5\u770B\u7ED3\u679C\u9519\u8BEF")];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    /*
  [{
    "data": [
      ["序列", "中奖时间", "收获地址", "邮编"],
      ["1","creatTime","XXX","XXX"]
    ],
    "name": "测试活动LSS1594797305510"
  }]
  */
    //导入发货状态信息
    BaseController.prototype.downloadFile = function (context, _a, _b) {
        var session = _a.session;
        var awardsService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var cloud, _c, activityId, fileName, fileId, result, total, sheets, data, i, prizeId, shipCompany, shipNum, result2, e_2;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        cloud = context.cloud;
                        _c = context.data, activityId = _c.activityId, fileName = _c.fileName;
                        console.log('====--=-=-=-=-', fileName);
                        fileId = fileName;
                        total = 0;
                        _d.label = 1;
                    case 1:
                        _d.trys.push([1, 9, , 10]);
                        return [4 /*yield*/, cloud.file.downloadFile({ fileId: fileId })];
                    case 2:
                        result = _d.sent();
                        sheets = xlsx.parse(result);
                        data = sheets[0].data;
                        if (!(data[1].length == 3)) return [3 /*break*/, 7];
                        i = 1;
                        _d.label = 3;
                    case 3:
                        if (!(i < data.length)) return [3 /*break*/, 6];
                        prizeId = data[i][0];
                        shipCompany = data[i][1];
                        shipNum = data[i][2];
                        return [4 /*yield*/, awardsService.setUserShipStatus(activityId, prizeId, shipCompany, shipNum)];
                    case 4:
                        result2 = _d.sent();
                        total += result2;
                        console.log('>>>');
                        _d.label = 5;
                    case 5:
                        i++;
                        return [3 /*break*/, 3];
                    case 6: return [2 /*return*/, sdk_1.resultsModel.success({ total: total, data: data })];
                    case 7: return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '导入文件格式错误')];
                    case 8: return [3 /*break*/, 10];
                    case 9:
                        e_2 = _d.sent();
                        console.log('e', e_2);
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '导入文件出现错误')];
                    case 10: return [2 /*return*/];
                }
            });
        });
    };
    __decorate([
        decorator_1.paramsCheck(['activityId']),
        decorator_1.services([service_1.AwardsService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "findWinnerInfoList", null);
    __decorate([
        decorator_1.paramsCheck(['activityId', 'title']),
        decorator_1.services([service_1.AwardsService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "exportAwardsList", null);
    __decorate([
        decorator_1.services([service_1.AwardsService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "exportAwardsInfoBySearch", null);
    __decorate([
        decorator_1.services([service_1.AwardsService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "findWinnerInfoListBySearch", null);
    __decorate([
        decorator_1.services([service_1.AwardsService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], BaseController.prototype, "downloadFile", null);
    return BaseController;
}());
exports.default = BaseController;
//# sourceMappingURL=awards.controller.js.map