function loginfo(context, handler) {
  const {
    fcName,
    data,
    env
  } = context;
  console.log(`函数名:${fcName}---函数handler:${handler}---当前环境:${env}---请求参数:${JSON.stringify(data)}`)
}
//判断网站域名
const urlCheck = (link, passUrlList) => {
  if (!link) {
    return {
      status: false,
      message: "请配置奖品的使用链接",
    }
  }
  if (!link.startsWith("http://") && !link.startsWith("https://")) {
    return {
      status: false,
      message: "页面链接必须以https://或http://开头",
    };
  }
  let passUrl = false;
  passUrlList.some((i) => {
    if (~link.indexOf(i)) {
      passUrl = true;
      return true;
    }
    return false;
  });
  if (!passUrl)
    return {
      status: false,
      message: "域名校验不通过",
    };
  return {
    status: true,
    message: "",
  };
};
const passUrlList = [
  '1688.cn',
  '1688.com',
  'alibaba.cn',
  'alibaba.com',
  'aliexpress.com',
  'alimama.cn',
  'alimama.com',
  'alipay.com.cn',
  'alipay.com',
  'alipay.net',
  'aliplay.com',
  'alisoft.cn',
  'alisoft.com',
  'aliyun.com',
  'aliyun.net',
  'koubei.cn',
  'koubei.com',
  'taobao.cn',
  'taobao.com',
  'taobao.net',
  'tb.cn',
  'tmall.com',
  'zhifu.com',
  'zhifubao.com',
  'juhuasuan.com',
  'tmall.hk',
  'tmall.com.hk',
  'jiyoujia.com',
  'pailitao.com',
  'cainiao.com',
  'dingtalk.com',
  'yushanfang.com',
  'guoguo-app.com',
  'alihealth.cn',
  'miaostreet.com',
  'uc123.com',
  'uc.cn',
  'ucweb.com',
  'aliyun-inc.com',
  'cainiaoyizhan.com',
  'umeng.com',
  'aliplus.com',
  'aliplay.com',
  'taopiaopiao.com',
  'youku.com',
  'tudou.com',
  'xinlingshou.cn',
  'fliggy.com',
  'feizhu.com',
  'feizhu.cn'
];
/**
 * 传入时间戳（毫秒）
 * 根据时间戳转换成number型日期进行差值结算，比如：2020318-2020317
 */
function isNewDay(time) {
  let date = new Date(time);
  let dateNum = +(date.getFullYear() + "" + (date.getMonth() + 1) + "" + date.getDate());

  let nowdate = new Date(Date.now());
  let nowdateNum = +(nowdate.getFullYear() + "" + (nowdate.getMonth() + 1) + "" + nowdate.getDate());
  return nowdateNum - dateNum > 0
}

const formatTime = function dateFormat(thisDate, fmt = "yyyy-MM-dd hh:mm:ss") {
  var o = {
    "M+": thisDate.getMonth() + 1,
    "d+": thisDate.getDate(),
    "h+": thisDate.getHours(),
    "m+": thisDate.getMinutes(),
    "s+": thisDate.getSeconds(),
    "q+": Math.floor((thisDate.getMonth() + 3) / 3),
    "S": thisDate.getMilliseconds()
  };
  if (/(y+)/.test(fmt))
    fmt = fmt.replace(RegExp.$1, (thisDate.getFullYear() + "").substr(4 - RegExp.$1.length));
  for (var k in o)
    if (new RegExp("(" + k + ")").test(fmt))
      fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
  return fmt;
}
//时间戳转为>2020/09/14
const formatDate = function (secs) { //123456789 --> 
  var t = new Date(secs);
  var year = t.getFullYear();
  var month = t.getMonth() + 1;
  if (month < 10) { month = '0' + month };
  var date = t.getDate();
  if (date < 10) { date = '0' + date };
  // var hour = t.getHours()
  // if (hour < 10) { hour = '0' + hour }
  // var minute = t.getMinutes()
  // if (minute < 10) { minute = '0' + minute }
  // var second = t.getSeconds()
  // if (second < 10) { second = '0' + second }
  return year + '/' + month + '/' + date;
  // + hour + ':' + minute + ':' + second
};

function MathRand() {
  var Num = "";
  for (var i = 0; i < 6; i++) {
    Num += Math.floor(Math.random() * 10);
  }
  return Num;
}
// 解决小数相加精度问题
function addFloat(num1, num2) {
  var r1, r2, m;
  r1 = num1.toString().split(".")[1] ? num1.toString().split(".")[1].length : 0;
  r2 = num2.toString().split(".")[1] ? num2.toString().split(".")[1].length : 0;
  m = Math.pow(10, Math.max(r1, r2));
  return (num1 * m + num2 * m) / m;
}
// 小数相除
const accMul = function (arg1, arg2) {
  var m = 0,
    s1 = arg1.toString();
    s2 = arg2.toString();
  try {
    m += s1.split(".")[1].length;
  } catch (e) { }
  try {
    m += s2.split(".")[1].length;
  } catch (e) { }
  return (
    (Number(s1.replace(".", "")) * Number(s2.replace(".", ""))) /
    Math.pow(10, m)
  );
};
// 小数相乘
const signFigures = function (num, rank = 6) {
  if (!num) return 0;
  const sign = num / Math.abs(num);
  const number = num * sign;
  const temp = rank - 1 - Math.floor(Math.log10(number));
  let ans;
  if (temp > 0) {
    ans = parseFloat(number.toFixed(temp));
  } else if (temp < 0) {
    ans = Math.round(number / Math.pow(10, temp)) * temp;
  } else {
    ans = Math.round(number);
  }
  return ans * sign;
};

module.exports = {
  loginfo,
  MathRand,
  passUrlList,
  urlCheck,
  isNewDay,
  formatTime,
  addFloat,
  formatDate,
  accMul,
  signFigures
}