// 排行榜开奖记录

const BaseDao = require("../dao/base.dao");
const { DRAW_STATUS, SHIP_STATUS } = require("../utils/constants");
const { USER_PRIZE } = require("../config/db_config");
const DBName = USER_PRIZE;
class RankopenprizeService {
  constructor(context) {
    this.rankopenprizeDao = new BaseDao(context, DBName);
  }

  // 添加排行榜待开奖列表
  async addWaitAwardsList(list) {
    if (!list.length) {
      return true;
    }
    list.map((v) => {
      (v.drawStatus = DRAW_STATUS.WAITAWARD), (v.message = "");
    });
    try {
      await this.rankopenprizeDao.insertMany(list);
      return true;
    } catch (e) {
      console.log(`添加排行榜待开奖列表出错：${e}`);
      return false;
    }
  }
  //获取中奖名单长度
  async getAwardslistCount(activityId, pageSize, pageNo) {
    if (!activityId) {
      return false;
    }
    return await this.rankopenprizeDao.count(
      {
        activityId: activityId,
      }
    );
  }
  // 根据活动id分页查找中奖名单
  async getAwardslistByActivityId(activityId, pageSize, pageNo) {
    if (!activityId) {
      return false;
    }
    return await this.rankopenprizeDao.find(
      {
        activityId: activityId,
      },
      {
        sort: {
          rank: 1
        },
        limit: pageSize,
        skip: (pageNo - 1) * pageSize,
      }
    );
  }

  //《条件搜索》查询中奖信息
  async getUserPrizeByActivityId(activityId, pageNo, pageSize, prizeId, userNick, timeStart, timeEnd, shipStatus, type, prizeDataType) {
    let p = prizeId ? { _id: prizeId } : '';
    let u = userNick ? { userNick: { $regex: ".*" + userNick + ".*" } } : '';
    let c = (timeStart > 0 && timeEnd > 0) ? { createTime: { $gt: timeStart, $lt: timeEnd } } : '';
    let s = shipStatus
      ? (shipStatus == 1
        ? { shipStatus: { $in: [SHIP_STATUS.NO_ADDRESS, SHIP_STATUS.NO_SHIP, SHIP_STATUS.HAS_SHIP] } }
        : (shipStatus == 2
          ? { shipStatus: { $in: [SHIP_STATUS.NO_ADDRESS, SHIP_STATUS.NO_SHIP] } }
          : { shipStatus: SHIP_STATUS.HAS_SHIP }
        )
      )
      : '';
    let t = type ? { type: +type } : '';
    let d = prizeDataType ? { prizeDataType: +prizeDataType } : '';
    let arr = [p, u, c, s, t, d];
    arr = arr.filter((i) => { return i });
    console.log('arr--222---', arr);
    return await this.rankopenprizeDao.find(
      {
        activityId,
        $and: arr
      },
      {
        limit: pageSize,
        skip: (pageNo - 1) * pageSize,
      }
    );
  }


  //《条件搜索》获取中奖名单长度
  async getTotalObjectCount(activityId, prizeId, userNick, timeStart, timeEnd, shipStatus, type, prizeDataType) {
    let p = prizeId ? { _id: prizeId } : '';
    let u = userNick ? { userNick: { $regex: ".*" + userNick + ".*" } } : '';
    let c = (timeStart > 0 && timeEnd > 0) ? { createTime: { $gt: timeStart, $lt: timeEnd } } : '';
    let s = shipStatus
      ? (shipStatus == 1
        ? { shipStatus: { $in: [SHIP_STATUS.NO_ADDRESS, SHIP_STATUS.NO_SHIP, SHIP_STATUS.HAS_SHIP] } }
        : (shipStatus == 2
          ? { shipStatus: { $in: [SHIP_STATUS.NO_ADDRESS, SHIP_STATUS.NO_SHIP] } }
          : { shipStatus: SHIP_STATUS.HAS_SHIP }
        )
      )
      : '';
    let t = type ? { type: +type } : '';
    let d = prizeDataType ? { prizeDataType: +prizeDataType } : '';
    let arr = [p, u, c, s, t, d];
    arr = arr.filter((i) => { return i });
    console.log('arr--111---', arr, "s>>>", s);
    return await this.rankopenprizeDao.count({
      activityId,
      $and: arr
    });
  }

  //《条件搜索》导入发货状态
  async setUserShipStatus(activityId, prizeId, shipCompany, shipNum) {
    prizeId = prizeId ? prizeId : "/";
    shipCompany = shipCompany ? shipCompany : '';
    shipNum = shipNum !== null ? shipNum : ''
    let status = 0;
    if (shipCompany && shipNum) {
      status = SHIP_STATUS.HAS_SHIP;
    } else {
      status = SHIP_STATUS.NO_SHIP;
    }
    if (status == SHIP_STATUS.HAS_SHIP) {
      return await this.rankopenprizeDao.update({
        activityId,
        _id: prizeId,
        shipStatus: SHIP_STATUS.NO_SHIP
      }, {
        $set: {
          shipCompany,
          shipNum,
          shipStatus: SHIP_STATUS.HAS_SHIP
        }
      })
    } else {
      return 0;
    }
  }
}

module.exports = RankopenprizeService;
