const BaseDao = require("../dao/base.dao");
const { ACTIVITY_SELLER_SAVE } = require("../config/db_config");

module.exports = class ActivitySellerService {
  constructor(context) {
    this.activitysellerDao = new BaseDao(context, ACTIVITY_SELLER_SAVE);
  }

  //保存商家授权信息
  async saveSellerInfo(sellerInfo) {
    return await this.activitysellerDao.insertOne({
      ...sellerInfo,
      updateTime: Date.now(),
      createTime: Date.now(),
    });
  }

  //查找商家授权信息
  async findSellerInfo(openId) {
    return await this.activitysellerDao.find({
      openId,
    });
  }

  //查找商家授权信息
  async getSellerInfoByUserNick(userNick) {
    let res = await this.activitysellerDao.find({
      userNick,
    });
    if (res && res[0]) {
      return res[0];
    }
    return false;
  }

  //更新商家授权信息
  async updateSellerInfo(openId, sellerInfo) {
    console.log(openId, sellerInfo, "openId, sellerInfo");
    return await this.activitysellerDao.update(
      {
        openId: openId,
      },
      {
        $set: {
          ...sellerInfo,
          updateTime: Date.now(),
        },
      }
    );
  }
};
