// 排行榜开奖记录

const BaseDao = require("../dao/base.dao");
const { DRAW_STATUS } = require("../utils/constants");

const { USER_PRIZE } = require("../config/db_config");
const DBName = USER_PRIZE;
class RankopenprizeService {
  constructor(context) {
    this.rankopenprizeDao = new BaseDao(context, DBName);
  }

  // 添加排行榜待开奖列表
  async addWaitAwardsList(list) {
    if (!list.length) {
      return true;
    }
    list.map((v) => {
      (v.drawStatus = DRAW_STATUS.WAITAWARD), (v.message = "");
    });
    try {
      await this.rankopenprizeDao.insertMany(list);
      return true;
    } catch (e) {
      console.log(`添加排行榜待开奖列表出错：${e}`);
      return false;
    }
  }

  // 根据活动id查找中奖名单
  async getAwardslistByActivityId(activityId) {
    if (!activityId) {
      return false;
    }
    return await this.rankopenprizeDao.find(
      {
        activityId: activityId,
      },
      {
        sort: {
          score: -1,
          rankTime: -1,
        },
      }
    );
  }
}

module.exports = RankopenprizeService;
