const RankscanService = require("../service/activityconfig.service");
const ActivityprizeService = require("../service/activityprize.service");
const RankscoreService = require("../service/rankscore.service");
const RankopenprizeService = require("../service/rankopenprize.service");
const ResultsModel = require("../utils/results.model");
const { Utils, EIGHT_HOURS } = require("../utils/constants");

let resultsModel = new ResultsModel();
// 声明排行榜扫描服务
let rankscanService = null;
// 声明奖品服务
let activityprizeService = null;
// 声明分数排行榜服务
let rankscoreService = null;
// 声明待开奖服务
let rankopenprizeService = null;

// 查询该活动的奖品列表 及 发奖数
const getPrizeListAndAwards = async (activityId) => {
  let prizeList = await activityprizeService.getPrizeListByActivityId(
    activityId
  );
  console.log(prizeList);
  // 若不存在奖品列表，则为脏数据，不做处理
  if (!prizeList.length) {
    console.log(`活动Id为${activityId}不存在对应的奖品信息`);
    return {
      prizeList: [],
      totalAwards: 0,
    };
  }
  // 获取总共发奖的个数
  let totalAwards = prizeList.reduce((total, curVal, curIndex, arr) => {
    // 当没有rank名次，直接返回
    if (!curVal.rank) {
      return total;
    }
    let awards = ~curVal.rank.indexOf("-")
      ? +curVal.rank.split("-")[1]
      : +curVal.rank;
    if (awards > total) {
      total = awards;
    }
    return total;
  }, 0);

  return {
    prizeList,
    totalAwards,
  };
};

// 获取待开奖列表
const getWaitAwardsList = (prizeList, topscoreList, totalAwards, shopId) => {
  let waitAwardslist = [];
  // 若分数排行榜没有数据，或发奖数为0，返回[]
  if (!totalAwards || !topscoreList.length) {
    return waitAwardslist;
  }
  prizeList.forEach((v, index, arr) => {
    if (!v.rank) {
      return;
    }
    let rankPeriod = ~v.rank.indexOf("-")
      ? v.rank.split("-")
      : [v.rank, v.rank];
    // 截取排行区间的分数排行列表
    let ranklist = topscoreList.slice(
      +rankPeriod[0] - 1,
      Math.min(+rankPeriod[1], totalAwards)
    );
    // 整合开奖数据
    ranklist.map((rank) => {
      waitAwardslist.push({
        activityId: v.activityId,
        openId: rank.openId,
        rankRange: v.rank,
        rank: rank.rank,
        ename: v.ename,
        startTime: v.startTime,
        endTime: v.endTime,
        prizeId: v._id,
        prizeName: v.name,
        userNick: rank.userNick,
        rankTime: rank.updateTime,
        image: v.image,
        maxScore: rank.maxScore,
        shopId: shopId,
        type: v.type || "",
        amount: v.amount || "",
        createDay: Utils.default.dateFormatter(
          new Date(Date.now() + EIGHT_HOURS),
          "yyyy/MM/dd"
        ),
      });
    });
  });
  return waitAwardslist;
};

// 设置活动开奖
const setActivity2openprize = async (waitAwardslist, _id) => {
  // 插入排行榜开奖记录表 rank_open_prize 若失败，则变更
  let results = await rankopenprizeService.addWaitAwardsList(waitAwardslist);
  console.log(`result: ${JSON.stringify(results)}`);
  if (results) {
    await rankscanService.update2Success(_id);
    console.log(`开奖成功`);
    return true;
  } else {
    await rankscanService.update2Fail(_id, `批量插入rank_open_prize表不成功`);
    console.log(`开奖失败`);
    return false;
  }
};

/**
 * 定时触发开奖
 */
const endingNotify = async (context) => {
  // 初始化排行榜扫描服务
  rankscanService = new RankscanService(context);
  // 初始化返回结果
  let results = {
    success: [],
    fails: [],
  };

  // 获取服务器时间
  let serverTime = Date.now();
  // 触发开奖列表
  let notifyList = await rankscanService.getNodifyList(serverTime);
  console.log(notifyList.length);

  if (!notifyList.length) {
    console.log(`没有待开奖的活动`);
    return resultsModel.success(results);
  }
  // 初始化奖品服务
  activityprizeService = new ActivityprizeService(context);
  // 分数排行榜
  rankscoreService = new RankscoreService(context);
  // 待开奖服务
  rankopenprizeService = new RankopenprizeService(context);

  // 遍历列表
  for (let i = 0; i < notifyList.length; i++) {
    let { _id, shopId } = notifyList[i];
    // 将该条记录变更为处理中
    let updateResult = await rankscanService.update2Process(_id);
    console.log(`updateResult: ${updateResult}`);
    if (!updateResult) {
      console.log(`将rank_scan该活动的开奖状态变更为处理中失败`);
      continue;
    }
    // 查询该活动的奖品列表 及 发奖数
    let { prizeList, totalAwards } = await getPrizeListAndAwards(_id);

    // console.log(
    //   `prizeList: ${JSON.stringify(prizeList)}; totalAwards: ${totalAwards}`
    // );
    // 没查找到奖品列表, 继续下个活动循环
    if (!prizeList.length) {
      // 开奖失败，记录日志
      await rankscanService.update2Fail(
        _id,
        `活动不存在对应的奖品列表，开奖失败`
      );
      results.fails.push(_id);
      continue;
    }
    // 查找排行榜分数榜里的前totalAwards个记录
    let topscoreList = await rankscoreService.getToplistByActivityId(
      _id,
      totalAwards
    );
    topscoreList = topscoreList.map((v, i) => {
      return { ...v, rank: i + 1 };
    });
    console.log(`topscoreList: ${JSON.stringify(topscoreList)}`);
    // 根据分数排行榜列表及奖品列表整合数据，待开奖列表
    let waitAwardslist = getWaitAwardsList(
      prizeList,
      topscoreList,
      totalAwards,
      shopId
    );
    // if (!waitAwardslist.length) {

    // }
    console.log(`waitAwardslist: ${JSON.stringify(waitAwardslist)}`);
    // 开奖
    let issuccess = await setActivity2openprize(waitAwardslist, _id);
    issuccess ? results.success.push(_id) : results.fails.push(_id);
    // end
  }
  return resultsModel.success(results);
};

module.exports = {
  endingNotify,
};
