const ActivityConfigService = require("../service/activityconfig.service");
const {
  CODE_TYPES,
  TASK_CHECK_TYPE,
  TASK_TYPE_CHINA,
  PRIZE_TYPE,
} = require("../utils/constants");
const ResultsModel = require("../utils/results.model");
let resultsModel = new ResultsModel();
const { DELETE_STATUS } = require("../utils/constants");
const ActivitySellerService = require("../service/activityseller.service");
let ActivityTopService = require("../service/activitytop.service");
let ActivityInstanceService = require("../service/activityinstance.service");
const { loginfo, passUrlList } = require("../utils/utils");

const regTestFn = (value, reg) => {
  return reg.test(value);
};

const getIds = (data) => {
  return data.reduce((s, v) => {
    if (v._id) {
      s = [...s, v._id];
    }
    return s;
  }, []);
};

const urlCheck = (link, passUrlList) => {
  if (!link.startsWith("http://") && !link.startsWith("https://")) {
    return {
      status: false,
      message: "页面链接必须以https://或http://开头",
    };
  }
  let passUrl = false;
  passUrlList.some((i) => {
    if (~link.indexOf(i)) {
      passUrl = true;
      return true;
    }
    return false;
  });
  if (!passUrl)
    return {
      status: false,
      message: "域名校验不通过",
    };
  return {
    status: true,
    message: "",
  };
};

//openId获取活动列表
const getActivityListByOpenId = async function (context) {
  loginfo(context, "getActivityListByOpenId");
  const { openId } = context;
  let ActivityConfig = new ActivityConfigService(context);
  try {
    let result = await ActivityConfig.getActivityListByOpenId(
      openId,
      context.data
    );
    if (result) {
      result.list.map((item) => {
        item.activityId = item._id;
        return item;
      });
      return resultsModel.success(result);
    }
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "查询活动列表失败");
  } catch (e) {
    console.log("catch", "查询活动列表失败");
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "查询活动列表失败");
  }
};

//保存或编辑活动信息
const saveActivityInfoByHasId = async function (context) {
  loginfo(context, "saveActivityInfoByHasId");
  let ActivityConfig = new ActivityConfigService(context);
  let ActivityTop = new ActivityTopService(context);
  let nowTime = Date.now();
  const { openId } = context;
  let {
    title = "",
    activityId = "",
    startTime,
    endTime,
    tasks = {},
    rule,
  } = context.data;
  let initialData;
  if (activityId) {
    initialData = await ActivityConfig.getActivityInfoByActivityId(activityId);
  }
  if (!title) {
    return resultsModel.error(CODE_TYPES.PARAMS_ERROR, "活动名称为空");
  } else if (title.length > 12) {
    return resultsModel.error(
      CODE_TYPES.PARAMS_ERROR,
      "活动名称不可超过12个字"
    );
  }
  const taskList = Object.keys(tasks).map(type => {
    return {
      ...tasks[type]
      type
    }
  })
  if (taskList.length === 0) {
    return resultsModel.error(CODE_TYPES.PARAMS_ERROR, "任务配置必须配置一项");
  } else {
    let canPassTask = { status: true, message: "" };
    taskList = taskList.map((i) => {
      if (!i.type) {
        canPassTask = {
          status: false,
          message: "任务必须配置",
        };
      }
      if (TASK_CHECK_TYPE.link.list.includes(i.type)) {
        if (canPassTask.status) {
          canPassTask = urlCheck(i.link, passUrlList);
        }
      }
      if (TASK_CHECK_TYPE.itemIds.list.includes(i.type)) {
        if (!i.itemIds) {
          canPassTask = {
            status: false,
            message: TASK_TYPE_CHINA[i.type] + "必须配置",
          };
        }
      }
      if (TASK_CHECK_TYPE.value.list.includes(i.type)) {
        if (!i.value) {
          canPassTask = {
            status: false,
            message: TASK_TYPE_CHINA[i.type] + "任务值必须配置",
          };
        }
        if (!regTestFn(i.value, TASK_CHECK_TYPE.value.reg)) {
          canPassTask = {
            status: false,
            message:
              TASK_TYPE_CHINA[i.type] +
              "任务值在" +
              TASK_CHECK_TYPE.value.regName,
          };
        }
      }
      if (TASK_CHECK_TYPE.times.list.includes(i.type)) {
        if (!i.times) {
          canPassTask = {
            status: false,
            message: TASK_TYPE_CHINA[i.type] + "任务次数必须配置",
          };
        }
      }
      if (TASK_CHECK_TYPE.title.list.includes(i.type)) {
        if (!i.title) {
          canPassTask = {
            status: false,
            message: TASK_TYPE_CHINA[i.type] + "任务标题必须配置",
          };
        }
      }
      if (TASK_CHECK_TYPE.taskRateType.list.includes(i.type)) {
        if (!i.taskRateType) {
          canPassTask = {
            status: false,
            message: TASK_TYPE_CHINA[i.type] + "任务类型必须配置",
          };
        }
      }
      i.value = +i.value;
      i.times = +i.times || "";
      i.taskRateType = +i.taskRateType || "";
      return i;
    });
    if (!canPassTask.status)
      return resultsModel.error(CODE_TYPES.PARAMS_ERROR, canPassTask.message);
  }
  if (prizeInfoList.length === 0) {
    return resultsModel.error(CODE_TYPES.PARAMS_ERROR, "请配置排行榜奖品");
  } else if (prizeInfoList.length > 8) {
    return resultsModel.error(CODE_TYPES.PARAMS_ERROR, "奖品最多配置8个档位");
  } else {
    let canPassPrize = { status: true, message: "" };
    prizeInfoList.forEach((item) => {
      if ((item.type === PRIZE_TYPE.EQUITY && !item.ename) || !item.rank) {
        canPassPrize.status = false;
        canPassPrize.message = "奖品配置参数缺失";
      }
    });
    let maxRank = ~prizeInfoList[prizeInfoList.length - 1].rank.indexOf("-")
      ? prizeInfoList[prizeInfoList.length - 1].rank.split("-")[1]
      : prizeInfoList[prizeInfoList.length - 1].rank;
    if (maxRank > 100)
      canPassPrize = { status: false, message: "奖品排名配置不可超过100" };
    if (!canPassPrize.status) {
      return resultsModel.error(CODE_TYPES.PARAMS_ERROR, canPassPrize.message);
    }
  }
  if (!rule) {
    return resultsModel.error(CODE_TYPES.PARAMS_ERROR, "活动规则不可为空");
  }
  if (!startTime || !endTime) {
    return resultsModel.error(CODE_TYPES.PARAMS_ERROR, "请配置活动时间");
  } else if (!activityId && startTime < Date.now()) {
    return resultsModel.error(
      CODE_TYPES.PARAMS_ERROR,
      "新建活动开始时间需小于当前时间"
    );
  } else if (startTime > endTime) {
    return resultsModel.error(
      CODE_TYPES.PARAMS_ERROR,
      "开始时间不得大于结束时间"
    );
  } else if (
    activityId &&
    +initialData.baseConfig.startTime <= nowTime &&
    nowTime <= +initialData.baseConfig.endTime
  ) {
    if (+startTime !== +initialData.baseConfig.startTime) {
      return resultsModel.error(
        CODE_TYPES.PARAMS_ERROR,
        "活动开始后不可更改活动开始时间"
      );
    }
  }
  console.log(shopInfoResult, "shopInfo");
  const baseData = {
    title,
    subtitle,
    startTime,
    endTime,
    rule,
    openId,
    tasks,
  };
  prizeInfoList = prizeInfoList.map((v, i) => {
    return { ...v, level: i + 1 };
  });
  let result;
  let allPrizeList = prizeInfoList;
  try {
    if (!activityId) {
      result = await ActivityConfig.saveNewActivity(
        baseData,
        prizeInfoList,
        openId
      );
    } else {
      result = await ActivityConfig.updateBaseConfigInfo(activityId, baseData);
      let allNewIds = getIds(allPrizeList);
      let oldPrizeList = await ActivityConfig.getAllOldPrizeList(activityId);
      let oldIds = getIds(oldPrizeList);
      let deleteIds = [];
      let bothIds = oldIds.reduce((s, i) => {
        if (allNewIds.includes(i)) {
          s = [...s, i];
        } else {
          deleteIds.push(i);
        }
        return s;
      }, []);
      for (let i = 0; i < deleteIds.length; i++) {
        result = await ActivityConfig.updateDeleteStatusById(deleteIds[i]);
      }
      for (let i = 0; i < allPrizeList.length; i++) {
        if (!allPrizeList[i]._id) {
          result = await ActivityConfig.insertPrizeByActivityId(
            activityId,
            allPrizeList[i]
          );
        } else if (bothIds.includes(allPrizeList[i]._id)) {
          result = await ActivityConfig.updateOnePrizeById(
            allPrizeList[i]._id,
            allPrizeList[i]
          );
        }
      }
    }
    if (result || result === 0) {
      return resultsModel.success(true);
    } else {
      console.log(result, "保存活动失败");
      return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "保存活动失败");
    }
  } catch (e) {
    console.log(e, "保存活动失败");
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "保存活动失败");
  }
};

//删除活动
const deleteActivityById = async function (context) {
  loginfo(context, "deleteActivityById");
  let ActivityConfig = new ActivityConfigService(context);
  const { activityId = "" } = context.data;
  try {
    if (activityId) {
      let result = await ActivityConfig.deleteActivityByActivityId(activityId);
      if (result === 0 || result) {
        return resultsModel.success(true);
      } else {
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "删除活动失败");
      }
    } else {
      return resultsModel.error(CODE_TYPES.PARAMS_ERROR, "删除活动id不存在");
    }
  } catch (e) {
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "删除活动失败");
  }
};

//获取活动信息
const getActivityInfo = async function (context) {
  loginfo(context, "getActivityInfoByActivityId");
  let ActivityConfig = new ActivityConfigService(context);
  const { activityId = "" } = context.data;
  try {
    if (activityId) {
      let result = await ActivityConfig.getActivityInfoByActivityId(activityId);
      let prizeInfoList = result.prizeConfig;
      let activityInfo = {
        activityId,
        ...result.baseConfig,
        prizeInfoList,
      };
      return resultsModel.success(activityInfo);
    } else {
      return resultsModel.error(CODE_TYPES.PARAMS_ERROR, "当前活动不存在");
    }
  } catch (e) {
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "获取活动配置信息失败");
  }
};

module.exports = {
  getActivityListByOpenId,
  saveActivityInfoByHasId,
  deleteActivityById,
  getActivityInfo,
};
