Page({
  data: {
    title: '',
    limitValue: '',
    rule: '',
    activityInfo: {
      startTime: '',
      endTime: '',
      originalStartTime: ''
    },
    probabilityRrizeRialogVisible: false,
    winnerDialogVisible: false,
    list: [
      {
        title:'第一期（6.16-6.23）',
        state: 0, //活动状态 0 已完成  1 进行中
        activityId: '123123',
        tableData:[
          {
            sort: 1,
            nick: 'bobo',
            type: '车',
            name: '小汽车',
            receiveName: 'bobo',
            phone: '1234567',
            address: '黄土高坡'
          },
        ]
      },
      {
        title:'第二期（6.24-7.23）',
        activityId: '1231231232',
        state: 1, //活动状态 0 已完成  1 进行中
        tableData:[
          {
            sort: 2,
            nick: 'bobo2',
            type: '飞机',
            name: '小飞机',
            receiveName: 'bobo2',
            phone: '12345678',
            address: '青藏高阿萨德爱的速递法司法或付首付原'
          }
        ]
      }
    ],
    listProp:{
      title: 'title',
      content: 'tableData',
      key: 'activityId',
      tableProps: [
        {
          title: '排名',
          value: 'sort',
        },
        {
          title: '用户昵称',
          value: 'nick',
        },
        {
          title: '奖品类型',
          value: 'type',
        },
        {
          title: '奖品名称',
          value: 'name',
        },
        {
          title: '收货人',
          value: 'receiveName',
        },
        {
          title: '联系方式',
          value: 'phone',
        },
        {
          title: '收货地址',
          value: 'address',
        }
      ]
    },
    width: 800,
    maxBodyHeight: 300,
    dialogTitle: 'XXX活动中奖信息'
  },
  onChange(e) {
    this.setData({
      title: e.detail.value
    })
  },
  onConfigInputChange(e) {
    this.setData({
      limitValue: e.detail.value
    })
  },
  onRuleChange(e) {
    this.setData({
      rule: e.detail.value
    })
  },
  onTimeChange(time) {
    console.log(time);
    const { activityInfo } = this.data;

    activityInfo.startTime = time[0];
    activityInfo.endTime = time[1]
    this.setData({
      activityInfo: {
        ...activityInfo
      }
    })
  },
  //展示中奖者列表弹窗
  onShowWinnerList() {
    this.setData({
      winnerDialogVisible: !this.winnerDialogVisible
    })
  },
  // 组件关闭回调
  onCloseDialog() {
    this.setData({
      winnerDialogVisible: false
    })
  },
  onLoad() {
    let activityInfo = {
      startTime: 1591340703158,
      endTime: 1592340433145
    }
    setTimeout(() => {
      activityInfo.originalStartTime = activityInfo.startTime;
      this.setData({
        activityInfo
      })
    }, 2000);
  },
});
