import { uploadDataCreateFile } from '/api';

Component({
  mixins: [],
  data: {
    showTableData: [],
    showTabKey: '',
    selectedItem: {},
    copyUrl: '',
    copyVisible: '',
  },
  props: {
    dialogTitle:'中奖信息', //弹窗头部文字定义
    visible: false, //弹窗显示控制
    onClose: () => {}, //弹窗关闭事件抛出
    list: [],  //弹窗所有数据列表
    width: 515,  //弹窗宽度
    listProp: {
      title: 'title',
      content: 'content',
      key: '',
      tableProps: [{
        title: '排名',
        value: 'sort',
      }]
    },//中奖弹窗内容字段配置，根据字段配置渲染相应数据的字段
    maxBodyHeight: 300  //中奖弹窗表格固定排头，设置最高高度
  },
  didMount() {
    //默认初始化选中第一跳数据
    this.selectedItem = this.props.list.length>0 ? this.props.list[0] : {}
    console.log(this.selectedItem)
  },
  didUpdate() {},
  didUnmount() {},
  methods: {
    closeDialog() {
      this.props.onClose();
    },
    onTabChange(e) {
      this.selectedItem = this.props.list.find(item => `.$${item[this.props.listProp.key]}` === e.detail.value)
    },
    //关闭导出弹窗
    onCopyClose() {
      this.setData({
        copyVisible: false
      })
    },
    // 导出中奖名单
    async exportWinnerList() {
      const { activityId } = this.selectedItem;
      const title = this.selectedItem[this.props.listProp.title];
      my.showLoading({
        content: '生成文件中...'
      })
      try {
        const { success, data, message } = await uploadDataCreateFile({
          activityId,
          title
        })
        my.hideLoading();
        
        if(success) {
          const copyUrl = data.url.replace(/amp;/g, '');
          this.setData({
            copyVisible: true,
            copyUrl,
          })
        } else {
          my.showToast({
            type: 'fail',
            content: message
          })
        }
      } catch (error) {
        my.hideLoading();
        console.log(error, 'exportList-error');
      }
      

    }
  },
});
