const { cloud } = getApp();
const { function: fc } = cloud;
const plugin = requirePlugin("myPlugin");
import { bizCode } from "/config";
import { queryBenefitByEname } from "/api";

import { chooseImage, getImageInfo, validateRangeNumber } from "/utils";

const EQUITY_TYPE = 1;
const CREDITS_TYPE = 2;
const OBJECT_TYPE = 3;
const THANKS_TYPE = 4;

const INIT_DATA =  {
  ename: "",
  stock: "",
  type: 1,
  image: "",
  credits: "",
  probablity: "",
  name: "",
  limitStock: 0,
  useStock: 0,
  rank: ""
};

Component({
  mixins: [],
  data: {
    EQUITY_TYPE,
    CREDITS_TYPE,
    OBJECT_TYPE,
    THANKS_TYPE,
    showDialogMask: true,
    dialogTop: "",
    rankTips: {
      status: "success",
      content: "",
    },
    imageTips: {
      status: "success",
      content: "",
    },
    probablityTips: {
      status: "success",
      content: "",
    },
    prizeNameTips: {
      status: "success",
      content: "",
    },
    prizeNumberTips: {
      status: "success",
      content: "",
    },
    creditsValueTips: {
      status: "success",
      content: "",
    },
    rankValueTips: {
      status: "success",
      content: "",
    },
    prizeInitData: {
      ename: "",
      id: "",
      stock: "",
      activityOutId: "",
      type: 1,
      image: "",
      credits: "",
      probablity: "",
      name: "",
      limitStock: 0,
      useStock: 0,
      rank: ""
    },
  },
  props: {
    prizeDialogData: {
      index: '',
      record: {}
    },
    maxRankLimit: '', // 限制最高排名
    type: 'probablity',  // 奖品弹窗类型  probablity: 概率  rank: 排名
    imageLimit: [ 200, 200 ],
    activityOutId: "",
    isEdit: false,
    visible: false,
    hasEditPrize: false,
    datasource: [],
    onCloseDialog: function () {},
    onUpdate: function () {}
  },
  didMount() {
    this.initPosition();
    this.resetPrizeInit();
    this.initBenefit();
   
  },
  methods: {
    initPosition() {
      const { scrollTop } = this.$page.data;
      this.setData({
        dialogTop: scrollTop * 2,
      });
    },
    initBenefit() {
      const that = this;
      const bridge = {
        bizCode, //此处输入想配置的商家应用appID
        //这个方法用于获取插件中用户选择的奖池enname
        async getCheckBenefitID({ ename, poolID }) {
          that.setData({
            prizeInitData: {
              ...that.data.prizeInitData,
              ename,
            },
          });
          my.showToast({
            type: "success",
            content: "已选择权益奖品",
          });
          const { success, data, message } = await queryBenefitByEname({ ename });
          if (success) {
            const { benefitName, rightTypeId, startTime, endTime, stock } = data[0];
            that.setData({
              prizeInitData: {
                ...that.data.prizeInitData,
                name: benefitName,
                type: EQUITY_TYPE,
                startTime,
                endTime,
                stock: stock
              },
            });
            that.$page.data.backPageTimeOut = setTimeout(() => {
              my.navigateBack({
                delta: 1,
              });
            }, 6000);
          } else {
            my.showToast({
              type: "fail",
              content: message,
            });
          }
        },
      };
      plugin.setBridge(bridge);
    },
    // 编辑更换类型时重置数据
    resetPrizeData(type, rank) {
      this.setData({
        prizeInitData: {
          ...INIT_DATA,
          type,
          rank
        },
      });
    },

    onPrizeTypeChange(e) {
      let value = e.detail.value;
      const { type, rank } = this.data.prizeInitData;
      let initData = {
        ename: "",
        stock: "",
        useStock: "",
        type: +value,
        image: "",
        credits: "",
        probablity: "",
        name: "",
        limitStock: 0
      };
      if(type !== value) {
        this.resetPrizeData(+value, rank);
        return;
      }
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          ...initData
        },
      });
    },
    navigateToPlugin() {
      clearTimeout(this.$page.data.backPageTimeOut);
      my.navigateTo({
        url: "plugin://myPlugin/orightindex-page",
      });
    },
    resetPrizeInit() {
      const { isEdit, prizeDialogData } = this.props;
      console.log(isEdit, prizeDialogData)
      if (isEdit) {
        console.log(prizeDialogData)
        const { ...rest } = prizeDialogData.record;
        this.setData({
          prizeInitData: {
            ...rest,
          },
        });
      } else {
        this.setData({
          prizeInitData: INIT_DATA
        });
      }
    },
    onLimitStockChange(e) {
      const value = e.detail.value;
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          limitStock: value,
          stock: value === 0 ? '' : this.data.prizeInitData.stock
        },
      });
    },
    async uploadImage() {
      try {
        this.setData({
          showDialogMask: false,
        });
        const res = await chooseImage();
        this.setData({
          showDialogMask: true
        });

        if (!res.apFilePaths.length) return;

        const { height, width, type, path } = await getImageInfo({
          src: res.apFilePaths[0],
        });
        const { imageLimit, maxRankLimit } = this.props;

        let imgBool = ~path.indexOf(".png") || ~path.indexOf(".jpg");
        if (height !== imageLimit[1] || width !== imageLimit[0] || !imgBool) {
          this.showItemTips("imageTips", "error", "请按要求上传图片");
          return;
        } else {
          this.showItemTips("imageTips", "success", "");
        }

        const { url } = await cloud.file.uploadFile({
          filePath: res.apFilePaths[0],
          fileType: "image",
          fileName: path.split("/").pop(),
        });


        this.setData({
          prizeInitData: {
            ...this.data.prizeInitData,
            image: url,
          },
          showDialogMask: true
        });
      } catch (error) {
        this.setData({
          showDialogMask: true,
        });
        console.error(error);
      }
    },
    onChangePrizeValue(e) {
      const key = e.target.dataset.name;
      const value = e.detail.value;
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          [key]: value,
        },
      });
    },
    changeInput(e) {
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          name: e.detail.value,
        },
      });
    },
    updatePrize() {
      const {
        name,
        ename,
        image,
        type,
        startTime,
        probablity,
        stock,
        credits,
        limitStock,
        endTime,
        rank,
        ...rest
      } = this.data.prizeInitData;
      const { imageTips } = this.data;
      const { type: dialogType, maxRankLimit } = this.props;

      let probablityRexp = /^\d+(\.\d{1,2})?$/;
      if (!probablityRexp.test(probablity) || probablity > 100) {
        this.showItemTips(
          "probablityTips",
          "error",
          "奖品概率必须在0-100%之间且最多支持两位小数"
        );
      } else {
        this.showItemTips("probablityTips", "success", "");
      }

      if(dialogType !== 'probablity') {
        this.showItemTips("probablityTips", "success", "");
      }

      const {
        LUKCY_POCKET_TYPE,
        COUPON_TYPE,
        CREDITS_TYPE,
        OBJECT_TYPE,
        THANKS_TYPE,
      } = this.data;

      if (type === LUKCY_POCKET_TYPE && !ename) {
        my.showToast({
          type: "fail",
          content: "优惠券配置错误, 请重新配置",
        });
        return;
      }

      if ((type == OBJECT_TYPE || type == CREDITS_TYPE) && !name) {
        this.showItemTips("prizeNameTips", "error", "请输入奖品名称");
      } else {
        this.showItemTips("prizeNameTips", "success", "");
      }

      if ((type == OBJECT_TYPE || type == EQUITY_TYPE) && limitStock && !validateRangeNumber(stock, [0, 9999])) {
        this.showItemTips(
          "prizeNumberTips",
          "error",
          "奖品库存为0-9999之间的整数"
        );
      } else {
        this.showItemTips("prizeNumberTips", "success", "");
      }

      if (type == CREDITS_TYPE && !validateRangeNumber(credits, [0, 999])) {
        this.showItemTips(
          "creditsValueTips",
          "error",
          "请输入积分价值为0-999的整数"
        );
      } else {
        this.showItemTips("creditsValueTips", "success", "");
      }

      if(dialogType === 'rank') {
        if(!rank) {
          this.showItemTips(
            "rankValueTips",
            "error",
            "请输入正确的领奖名次"
          );
        } else {
          this.showItemTips("rankValueTips", "success", "");
        }
        
      }
      const rankArr = rank.split('-');
      if(dialogType === 'rank' && maxRankLimit && rankArr[rankArr.length - 1] > maxRankLimit ) {
        my.showToast({
          type: "fail",
          content: `最多配置前${maxRankLimit}名奖品`
        });
        return;
      }

      const { probablityTips, prizeNumberTips, creditsValueTips } = this.data;
      const isImagePass = image && imageTips.status !== "error";

      let stockPass = true;
      if(limitStock && !stock) {
        stockPass = false;
      }
      const isEquietyPass =
        type == EQUITY_TYPE &&
        name.trim() &&
        isImagePass &&
        ename &&
        probablityTips.status !== "error";
      const isObjectPass =
        type == OBJECT_TYPE &&
        name.trim() &&
        stockPass &&
        isImagePass &&
        probablityTips.status !== "error" &&
        prizeNumberTips.status !== "error"
      const isCreditsPass =
        type == CREDITS_TYPE &&
        name.trim() &&
        credits &&
        isImagePass &&
        probablityTips.status !== "error" &&
        creditsValueTips.status !== "error";

      if (isEquietyPass || isObjectPass || isCreditsPass) {
        const { isEdit, prizeDialogData, onUpdate, onAdd } = this.props;
        let prizeData = {
          image,
          name,
          ename,
          type,
          probablity,
          stock,
          credits,
          rank,
          limitStock,
          ...rest,
        };

        if(isEdit) {
          console.log(prizeData, '--prizeData--')
          onUpdate && onUpdate(prizeData, prizeDialogData.index);
        } else {
          onAdd && onAdd(prizeData)
        }
        
        this.onCloseDialog();
      } else {
        my.showToast({
          type: "fail",
          content: "请完整填写奖品信息",
        });
      }
    },
    showItemTips(type, status, content) {
      this.setData({
        [type]: {
          status,
          content,
        },
      });
    },
    onCloseDialog() {
      this.props.onClose && this.props.onClose();
    },
  },
});
