const BaseDao = require("../dao/base.dao");
const { USER_INFO } = require("../config/db_config");
const DBName = USER_INFO;
class RankscoreService {
  constructor(context) {
    this.rankscoreDao = new BaseDao(context, DBName);
  }

  // 根据活动id查询分数排行榜
  async getToplistByActivityId(activityId, totalAwards) {
    let list = await this.rankscoreDao.find(
      {
        activityId: activityId,
        maxScore: { $ne: 0 },
      },
      {
        sort: {
          maxScore: -1,
          updateScoreTime: 1,
        },
        limit: +totalAwards,
      }
    );
    console.log(`getToplistByActivityId: ${JSON.stringify(list)}`);
    return list;
  }
}

module.exports = RankscoreService;
