const BaseDao = require("../dao/base.dao");
const { ACTIVITY_INSTANCE } = require("../config/db_config");

module.exports = class ActivitySellerService {
  constructor(context) {
    this.activityinstanceDao = new BaseDao(context, ACTIVITY_INSTANCE);
  }

  //保存商家授权信息
  async saveInstanceInfo(instanceInfo) {
    return await this.activityinstanceDao.insertOne({
      ...instanceInfo,
      updateTime: Date.now(),
      createTime: Date.now(),
    });
  }

  //查找商家授权信息
  async findInstanceInfo(openId) {
    return await this.activityinstanceDao.find({
      openId,
    });
  }

  //更新商家授权信息
  async updateInstanceInfo(openId, updateinfo) {
    return await this.activityinstanceDao.update(
      {
        openId,
      },
      {
        $set: {
          ...updateinfo,
          updateTime: Date.now(),
        },
      }
    );
  }

  async getMiniAppInstanceInfoByNick(userNick) {
    let res = await this.activityinstanceDao.find({
      userNick,
    });
    if (res && res[0]) {
      return res[0];
    }
    return false;
  }
};
