export const methods = {
  methods: {
    // 根据dataName  改变值
    onInputChangeByDataName(e) {
      const { name } = e.target.dataset;
      const { value } = e.detail;
      this.setDataByKey(value, name);
    },
    onTimeChange(timeRange, error) {
      const {
        formState
      } = this.data;

      this.setData({
        timeRange,
        startTime: timeRange[0],
        endTime: timeRange[1],
        formState: {
          ...formState,
          timeRange: {
            status: error ? 'error' : 'success',
            message: error || ''
          }
        }
      })
    },
    onChangeByDataName(val, key) {
      this.setDataByKey(val, key)
    },
    /**
     *根据key值改变数据, 支持key  a/a.b/a.b.c的形式
    *
    * @param {*} val
    * @param {string} key  
    */
    setDataByKey(val, key) {
      const keys = key.split('.');
      if (keys.length === 1) {
        this.setData({
          [keys[0]]: val
        })
      }
      if (keys.length === 2) {
        let targetKey = this.data[keys[0]];
        targetKey[keys[1]] = val;
        let newVal = Object.assign({}, targetKey)
        this.setData({
          [keys[0]]: newVal
        })
      }
      if (keys.length === 3) {
        let targetKey = this.data[keys[0]];
        targetKey[keys[1]][keys[2]] = val;
        let newVal = Object.assign({}, targetKey)
        this.setData({
          [keys[0]]: newVal
        })
      }
    }
  }
  
}