import moment from 'moment'
import schema from 'async-validator'
import { methods } from './mixins'
import {
  descriptor,
  formatValidator
} from './validate'
import {
  getActivityDetail,
  saveActivityInfo,
} from '/api'
import {
  addFloat
} from '/utils/helper'

const THANKS_TYPE = 5

var validator = new schema(descriptor)

   // {
      //   type: "beMembership",//会员
      //   value: 20,//完成任务获得值
      // },
      // {
      //   type: "attentionStore",
      //   value: 20,
      // },
      // {
      //   type: "sign",
      //   value: 20,
      // },
      // {
      //   type: "exchangeCredits",
      //   value: 20,
      //   times: 1,
      // },
      // {
      //   type: "inviteFriends",
      //   title: "标题",//任务标题
      //   taskRateType: 1,//任务频率类型
      //   times: 3,//任务为每日限次次数值
      //   value: 30,
      // },
      // {
      //   type: "orderGoods",
      //   title: "标题",
      //   taskRateType: 2,
      //   times: 3,
      //   value: 90,
      //   itemIds: "111,222,333",//商品类型任务商品id
      // },
      // {
      //   type: "browseGoods",
      //   title: "标题",
      //   taskRateType: 3,
      //   times: 3,
      //   value: 90,
      //   itemIds: "111,222,333",
      // },
      // {
      //   type: "jumpLink",
      //   title: "标题",
      //   taskRateType: 3,
      //   link: "http://www.taobao.com",//跳转链接
      //   times: 3,
      //   value: 90,
      // },
      // {
      //   type: "collectGoods",
      //   title: "标题",
      //   taskRateType: 1,
      //   times: 3,
      //   value: 90,
      //   itemIds: "111,222,333",
      // }
Component({
  mixins: [ methods ],
  data: {
    labelCol: { fixedSpan: 5 },
    id: '',
    startTime: '',
    endTime: '',
    <% for(var i = 0; i < configList.length; ++i) {%>
    <%- !taskKeys.includes(configList[i].key) && configList[i].key !== 'label' ? `${configList[i].key}: ${configList[i].defaultValue || "''"},` : ''  %><% } %>
    tasks: {
      attentionStore: {
        value: '',
      },
      beMembership: {
        value: '',
      },
      sign: {
        value: ''
      },
      exchangeCredits: {
        value: '',
        times: '',
      },
      inviteFriends: {
        title: '', // 任务标题
        taskRateType: 1, // 任务频率类型
        times: 3, // 任务为每日限次次数值
        value: '', // 任务奖励
      },
      browseGoods: {
        title: '',
        taskRateType: 1,
        times: 3,
        value: '',
        link: '',
        itemIds: '',
      },
      orderGoods: {
        title: '',
        taskRateType: 1,
        times: 3,
        value: '',
        link: '',
        itemIds: '',
      },
      collectGoods: {
        title: '',
        taskRateType: 1,
        times: 3,
        value: '',
        itemIds: "",
      },
      jumpLink: {
        title: '',
        taskRateType: 1,
        link: '', //跳转链接
        times: 3,
        value: '',
      },
    },
    isEnd: false,
    isStart: false,
    originalStartTime: '',
    formState: formatValidator(descriptor)
  },
  didMount() {
    const { id } = this.$page.$router.params
    id && this.getActivityInfo(id)
  },
  methods: {
    // 获取activityId活动信息
    async getActivityInfo(activityId) {
      try {
        const { success, data, message } = await getActivityDetail({ activityId})
        if (!success) {
          this.showFailToast(message);
          return;
        }

        this.setData({
          ...data,
          timeRange: [+data.startTime, +data.endTime],
          originalStartTime: +data.startTime,
          isStart: +data.startTime < Date.now(),
          isEnd: +data.endTime < Date.now(),
          tasks
        })

      } catch (error) {
        console.log(error, 'err')
      }
    },
    validateForm(data, target) {
      const _this = this;
      return new Promise((resolve, reject) => {
        validator.validate(data, (errors, fields) => {
          console.log('errors', errors);
          console.log('fields', fields);
          const {
            formState
          } = _this.data;
          _this.setFormTips(formState, errors, target)
          if (errors) {
            resolve(false);
          } else {
            resolve(true);
          }

          // validation passed
        });
      })
    },
    setFormTips(formState, errors, target) {
      errors = errors || []
      let newValidator = {};
      Object.keys(formState).forEach(key => {
        let error = errors.filter(v => target ? v.field === target && v.field === key : v.field === key).length && errors.filter(v => v.field === key)[0];
        // 时间实时校验
        if (key === 'timeRange' && formState[key].status === 'error') {
          return
        }
        newValidator[key] = {
          status: error ? 'error' : 'success',
          message: error ? error.message : ''
        }
      })

      console.log('newValidator', newValidator)

      this.setData({
        formState: newValidator
      })
    },
    // 提交信息
    async onSubmit() {

      console.log(this.data, 'this.data')

      const isValidForm = await this.validateForm(this.data);
      if (!isValidForm) return;
      console.log('成功')
      
      const params = this.formatActivityParams(this.data)
      console.log(params, 'params')
      const { success, message } = await saveActivityInfo(params)

      if(success) {
        this.backList()
      } else {
        this.showFailToast(res.message)
      }
    },
    showFailToast(text) {
      my.showToast({
        type: 'fail',
        content: text
      })
    },
    // 格式化参数
    formatActivityParams(params) {
      const {
        id = '',
        activityId = '',
        startTime,
        endTime,
        tasks,
        <% for(var i = 0; i < configList.length; ++i) {%>
        <%- !taskKeys.includes(configList[i].key) && configList[i].key !== 'label' ? configList[i].key + ',' : ''  %><% } %>
      } = params;


      return {
        id,
        activityId,
        startTime: new Date(startTime).getTime(),
        endTime: new Date(endTime).getTime(),
        tasks,
       // prizeInfoList: this.formatPrizeList(prizeInfoList),
        <% for(var i = 0; i < configList.length; ++i) {%>
        <%- !taskKeys.includes(configList[i].key) && configList[i].key !== 'label' ? configList[i].key + ',' : ''  %><% } %>
      }
    },
    // 补足谢谢参与类型
    formatPrizeList(prizeInfoList = []) {
      let totalPercent = prizeInfoList.reduce((total, next) => {
        return total = addFloat(total, +next.probablity)
      }, 0)
      // 排名类型不含谢谢参与
      if (prizeInfoList[0].rank) return prizeInfoList;
      let prizeInfoListCopy = prizeInfoList.concat().map((v, index) => ({
        ...v,
        level: index
      }));

      if (totalPercent < 100) {
        let thanksType = {
          type: THANKS_TYPE,
          name: '谢谢参与',
          probablity: 100 - totalPercent
        }
        prizeInfoListCopy.push(thanksType)
      }
      return prizeInfoListCopy
    },
    backList() {
      this.$page.$router.push("/activity/list");
    }
  },
})