
import {
  findWinnerInfoList,
  uploadDataCreateFile,
} from "/api";
import { appId } from "/config";
import { setClipboard } from "/utils";

Component({
  mixins: [],
  data: {
    tabs: [{
      tab: '0608-0712',
      key: 111
    },{
      tab: '03308-0712',
      key: 43
    },{
      tab: '064548-0712',
      key: 435
    },{
      tab: '0608-0712',
      key: 436545
    },{
      tab: '0608-0712',
      key: 65
    },{
      tab: '0608-0712',
      key: 11561
    },{
      tab: '0608-0712',
      key: 13311
    },{
      tab: '0608-0712',
      key: 145611
    },{
      tab: '0608-0712',
      key: 1178761
    }],
    dataSource: [],
    columns: [
      { title: '排名', prop: 'rank' },
      { title: '用户昵称', prop: 'userNick' },
      { title: '奖品类型', prop: 'typeName' },
      { title: '奖品名称', prop: 'prizeName' },
      { title: '收货人', prop: 'receiveName' },
      { title: '联系方式', prop: 'phone' },
      { title: '收货地址', prop: 'address', width: 240 }
    ],
    pageInfo: {
      pageNo: 1,
      pageSize: 100,
      total: 0
    },
  },
  props: {
    onClose: () => {},
    list: [],
    selectedItem: {},
  },
  didMount() {},
  didUpdate() {},
  didUnmount() {},
  methods: {
    async getWinnerList() {
      const { avtivityId } = this.props;
      const { data } = await findWinnerInfoList({
        avtivityId
      })

      this.setData({
        dataSource: data
      })

    },
    onCloseDialog() {
      this.props.onClose && this.props.onClose();
    },
    // 导出中奖名单
    async exportWinnerList(evt) {
      const { activityId, title } = this.props.selectedItem;
      const { type } = evt.target.dataset;
      my.showLoading({ content: "生成文件中..." });
      try {
        const { success, data, message } = await uploadDataCreateFile({
          activityId,
          title
        });
        my.hideLoading();

        if (success) {
          await setClipboard({ text: data.url.replace(/amp;/g, "") });
          my.showToast({
            type: 'success',
            content: '下载链接复制成功,请在浏览器中打开下载'
          });
          this.setData({
            exportDialogVisible: true,
            exportUrl: data.url.replace(/amp;/g, "")
          })
        } else {
          my.showToast({
            type: "fail",
            content: message,
          });
        }
      } catch (error) {
        my.hideLoading();
        console.log(error, "exportList-error");
      }
    },
  },
});
