/** @format */

import { Rules } from 'async-validator'
import { TASK_CHECK_TYPE, TASK_TYPE_TEXT, PASS_URL_LIST } from '../constants'

export const saveParams: Rules = {
  title: {
    required: true,
    type: 'string',
    validator(rule, value, cb, source) {
      value = value.trim()
      if (!value) return new Error('活动名称为空')
      if (value.length > 12) return new Error('活动名称不可超过12个字')
      return cb()
    }
  },
  rule: {
    required: true,
    message: '活动规则不可为空'
  },
  startTime: {
    required: true,
    validator(rule, value, cb, source) {
      const { endTime, activityId } = source
      if (!value) return new Error('请配置活动开始时间')
      if (value > endTime) return new Error('开始时间不得大于结束时间')
      if (!activityId && value < Date.now()) return new Error('新建活动开始时间需小于当前时间')
      return cb()
    }
  },
  endTime: {
    required: true,
    validator(rule, value, cb, source) {
      if (!value) return new Error('请配置活动结束时间')
      return cb()
    }
  }
}

const urlCheck = (link: string, passUrlList: string[]) => {
  if (!link.startsWith('http://') && !link.startsWith('https://')) {
    return { status: false, message: '页面链接必须以https://或http://开头' }
  }
  let passUrl = false
  passUrlList.some(i => {
    if (~link.indexOf(i)) {
      passUrl = true
      return true
    }
    return false
  })
  if (!passUrl)
    return {
      status: false,
      message: '域名校验不通过'
    }
  return {
    status: true,
    message: ''
  }
}
