const {
  cloud
} = getApp();

import { requestType, cloudFnName, cCloudFnName } from '../config';

const request = (url, method, params, ext = {}) => {
  const {
    isShowLoading,
    cloudFnType
  } = ext;
  const hideMyLoading = () => {
    if (isShowLoading) {
      my.hideLoading();
    }
  };
  if (isShowLoading) {
    my.showLoading();
  }

  // 云函数名
  const cloudFn = cloudFnType === 'c' ? cCloudFnName : cloudFnName;

  const requestAms = () => {
    return my.request({
      url: `https://ams.dui88.com/server/index.php?g=Web&c=Mock&o=simple&projectID=218&uri=${cloudFn}.${url}`,
      method,
      data: params,
      dataType: 'json'
    }).then(res => {
      hideMyLoading();
      return res.data;
    }).catch(() => {
      hideMyLoading();
    });
  };

  const requestCloud = () => {
    return cloud.function.invoke(cloudFn, params, url).then(res => {
      hideMyLoading();
      return res;
    }).catch(() => {
      hideMyLoading();
    });
  };

  return requestType === 'ams' ? requestAms() : requestCloud();
};

export default request;