/**
 * 获取表单数据
 * @param {*} dataList 
 */
export function getFormInfo(dataList) {
  const formData = {}
  const formState = {}
  for (let item of dataList) {
    // 如果元素类型不等于title，记录为表单元素
    if (item.htmlType !== 'Title') {
      formData[item.filed] = item.defaultValue
      formState[item.filed] = {
        status: true,
        message: ''
      }
    }
  }
  return {
    formData,
    formState
  }
}

/**
 * 解析数据为表单数据-获取使用
 */
export function parsingFormData(data) {
  const parsingData = {}
  for (let k in data) {
    const value = data[k]
    // 判断数据是不是对象
    const type = Object.prototype.toString.call(value)
    if (type.includes('Object')) {
      for (let j in value) {
        parsingData[`${k}.${j}`] = value[j]
      }
    } else {
      parsingData[k] = value
    }
  }
  return parsingData
}

/**
 * 格式化表单-提交使用
 */
export function formatFormData(formData) {
  const formatData = {}
  for (let key in formData) {
    const keys = key.split('.')
    const value = formData[key]
    if (keys.length === 1) {
      formatData[key] = value
    } else if (keys.length === 2){
      if (!!formatData[keys[0]]) {
        formatData[keys[0]][keys[1]] = value
      } else {
        formatData[keys[0]] = {
          [keys[1]]: value
        }
      }
    }
  }
  return formatData
}