import { valiResultModal, rankTableValidator, validateRangeNumber, rankTimeValidator, isNumber, isDot, validatePositiveInteger, validateInteger, urlChecks, rateTableValidator } from "./utils/validate";
import { passUrlList, urlCheck } from "./utils/helper";
import { AWARD_TYPE, BENEFIT_TYPE, STOCK_TYPE } from './constant'

const { EQUITY_TYPE, CREDITS_TYPE, OBJECT_TYPE } = AWARD_TYPE
const { SIMPLE_EQUITY, MEMBER_EQUITY } = BENEFIT_TYPE
const { STOCK_LIMIT } = STOCK_TYPE

const projectData = {
  appId: "3000000049416111", // 小程序appId
  bizCode: "3000000049414855", // 配置应用appID, 权益插件用
  appName: "模版活动", // 活动名称
  activityList: { // 活动列表
    listButtons: ["edit", "delete", "copyLink", "exportWinnerList", "copyNewActivity", "exportStatistics", "dataBoard"], // 列表配置项 edit-编辑活动、delete-删除活动、copyLink-复制活动链接、exportWinnerList-导出中奖名单、copyNewActivity-复制新活动、exportStatistics-导出数据需求、dataBoard-数据看板
    dataBoardBtnShowEnv: ['test', 'pre', 'online'], // 数据看板展示环境
    winnerDialog: { // 中奖弹窗配置
      isLogistics: true, // 是否需要物流
      prizeTypes: [{ name: "优惠券", value: 1 }, { name: "积分", value: 2 }, { name: "实物", value: 3 }, { name: "谢谢参与", value: 5 }], // 奖品类型集合-筛选
      prizeTypesObj: { 1: "优惠券", 2: "积分", 3: "实物", 5: "谢谢参与" },
      prizeDataTypes: [{ name: "普通奖池", value: 1 }, { name: "排行榜奖池", value: 2 }], // 发奖来源集合
      prizeDataTypesObj: { 1: "普通奖池", 2: "排行榜奖池" },
      filters: ["prizeId", "userNick", "timeRange", "shipStatus", "prizeType", "prizeDataType"], // 筛选条件 prizeId-奖品编号、userNick-用户id、timeRange-发奖时间、shipStatus-发货状态、prizeType-奖品类型、prizeDataType-发奖来源
      tableData: ["_id", "userNick", "createTime", "receiveTime", "type", "name", "prizeDataType", "receiveName", "shipStatus", "shipCompany"], // 列表展示数据  _id-奖品编号、userNick-用户id、createTime-发奖时间、receiveTime-填写地址时间、type-奖品类型、name-奖品名称、prizeDataType-发奖来源、receiveName-收货信息（联系人+详细地址）、shipStatus-发货状态、shipCompany-物流信息
    },
  },
  activityAddData: [ // 活动管理数据
    {
      name: '基础配置',
      htmlType: "Title"
    },
    {
      name: "活动名称", // 名称
      filed: "title", // 字段
      htmlType: "Input", // html类型 Input、InputTxt、TextArea、ActivityRangeTime、UploadImage、ChooseItems、Task、TaskReward、Award、Select、Radio...
      required: true, // 是否必填
      validator: (value, formData) => {
        let status = true, msg = ''
        if (!value.trim()) {
          status = false
          msg = '请填写活动名称'
        } else if (value.length > 12) {
          status = false
          msg = '活动名称不超过12字'
        }
        return valiResultModal(status, msg)
      }, // 校验规则
      placeholder: "请输入活动名称",
      defaultValue: ''
    },
    {
      name: "活动时间",
      filed: "timeRange",
      htmlType: "ActivityRangeTime",
      required: true, // 是否必填
      validator: (value, formData) => {
        return valiResultModal(!!value.every(v => !!v), '请选择活动时间')
      },
      defaultValue: []
    },
    {
      name: "活动规则",
      filed: "rule",
      htmlType: "TextArea",
      required: true, // 是否必填
      validator: (value, formData) => {
        let status = true, msg = ''
        if (!value.trim()) {
          status = false
          msg = '请填写活动规则'
        } else if (value.length > 2000) {
          status = false
          msg = '活动规则内容不超过2000字'
        }
        return valiResultModal(status, msg)
      },
      defaultValue: ''
    },
    {
      name: "中奖概率",
      filed: "winProbability",
      htmlType: "InputTxt",
      required: true, // 是否必填
      validator: (value, formData) => {
        return valiResultModal(!!validateRangeNumber(value, [0, 100], 2), '请输入0-100的中奖概率，最多保留两位小数')
      },
      afterTxt: "%", // 输入框后文案 htmlType为InputTxt配置
      defaultValue: ''
    },
    {
      name: "分享图片",
      filed: "shareImg",
      htmlType: "UploadImage",
      required: true, // 是否必填
      validator: (value, formData) => {
        return valiResultModal(!!value, '请选择分享图片')
      },
      imgWidth: 250, // 图片宽
      imgHeight: 250, // 图片高 htmlType为UploadImage配置
      defaultValue: ''
    },
    {
      name: '任务配置',
      htmlType: "Title"
    },
    {
      name: "每日签到",
      filed: "tasks.sign", // 字段，如tasks.sign
      htmlType: "Task",
      required: true, // 是否必填
      validator: (task) => {
        return valiResultModal(!!task.reward, '请完成每日签到任务配置')
      },
      mode: "custom", // 配置模式 fixed-固定配置 custom-B端配置
      unit: '体力',
      defaultValue: {
        title: "", // 任务名称
        rateType: 1, // 任务类型 1永久｜2每日｜3永久限时｜4每日限时｜5无限制
        times: 2, // 每日上限
        reward: "" // 奖品值
      }
    },
    {
      name: "关注店铺",
      filed: "tasks.follow", // 字段，如tasks.sign
      htmlType: "TaskReward",
      required: true, // 是否必填
      validator: (task) => {
        return valiResultModal(!!task.reward, '请完成关注店铺任务配置')
      },
      mode: "custom", // 配置模式 fixed-固定配置 custom-B端配置
      unit: '体力',
      defaultValue: {
        title: "", // 任务名称
        rateType: 1, // 任务类型 1永久｜2每日｜3永久限时｜4每日限时｜5无限制
        times: 1, // 每日上限
        reward: "" // 奖品值
      }
    },
    {
      name: "加入会员",
      filed: "tasks.member", // 字段，如tasks.sign
      htmlType: "Task",
      required: true, // 是否必填
      validator: (task) => {
        return valiResultModal(!!task.reward, '请完成加入会员任务配置')
      },
      mode: "custom", // 配置模式 fixed-固定配置 custom-B端配置
      unit: '体力',
      defaultValue: {
        title: "", // 任务名称
        rateType: 1, // 任务类型 1永久｜2每日｜3永久限时｜4每日限时｜5无限制
        times: 2, // 每日上限
        reward: "" // 奖品值
      }
    },
    {
      name: "兑换积分",
      filed: "tasks.exchangeCredits", // 字段，如tasks.sign
      htmlType: "Task",
      required: true, // 是否必填
      validator: (task) => {
        return valiResultModal(!!task.reward, '请完成兑换积分任务配置')
      },
      mode: "custom", // 配置模式 fixed-固定配置 custom-B端配置
      unit: '体力',
      defaultValue: {
        title: "", // 任务名称
        rateType: 1, // 任务类型 1永久｜2每日｜3永久限时｜4每日限时｜5无限制
        times: 2, // 每日上限
        reward: "" // 奖品值
      }
    },
    {
      name: "邀请好友",
      filed: "tasks.invite", // 字段，如tasks.sign
      htmlType: "Task",
      required: true, // 是否必填
      validator: (task) => {
        return valiResultModal(!!task.reward, '请完成邀请好友任务配置')
      },
      mode: "custom", // 配置模式 fixed-固定配置 custom-B端配置
      unit: '体力',
      defaultValue: {
        title: "", // 任务名称
        rateType: 1, // 任务类型 1永久｜2每日｜3永久限时｜4每日限时｜5无限制
        times: 2, // 每日上限
        reward: "" // 奖品值
      }
    },
    {
      name: "浏览商品",
      filed: "tasks.browse", // 字段，如tasks.sign
      htmlType: "Task",
      required: true, // 是否必填
      validator: (task) => {
        return valiResultModal(!!task.itemIds, '请完成浏览商品任务配置')
      },
      mode: "custom", // 配置模式 fixed-固定配置 custom-B端配置
      unit: '体力',
      hasItems: true,
      defaultValue: {
        title: "", // 任务名称
        rateType: 1, // 任务类型 1永久｜2每日｜3永久限时｜4每日限时｜5无限制
        times: 2, // 每日上限
        itemIds: '', // 任务商品
        reward: "" // 奖品值
      }
    },
    {
      name: "下单商品",
      filed: "tasks.order", // 字段，如tasks.sign
      htmlType: "Task",
      required: true, // 是否必填
      validator: (task) => {
        return valiResultModal(!!task.reward, '请完成下单商品任务配置')
      },
      mode: "custom", // 配置模式 fixed-固定配置 custom-B端配置
      unit: '体力',
      hasLink: true,
      defaultValue: {
        title: "", // 任务名称
        rateType: 1, // 任务类型 1永久｜2每日｜3永久限时｜4每日限时｜5无限制
        times: 2, // 每日上限
        jumpLink: '',
        reward: "" // 奖品值
      }
    },
    {
      name: "收藏商品",
      filed: "tasks.collect", // 字段，如tasks.sign
      htmlType: "Task",
      required: true, // 是否必填
      validator: (task) => {
        return valiResultModal(!!task.itemIds, '请完成收藏商品任务配置')
      },
      mode: "custom", // 配置模式 fixed-固定配置 custom-B端配置
      unit: '体力',
      hasItems: true,
      defaultValue: {
        title: "", // 任务名称
        rateType: 1, // 任务类型 1永久｜2每日｜3永久限时｜4每日限时｜5无限制
        times: 2, // 每日上限
        itemIds: '',
        reward: "" // 奖品值
      }
    },
    {
      name: "跳转链接",
      filed: "tasks.jump", // 字段，如tasks.sign
      htmlType: "Task",
      required: true, // 是否必填
      validator: (task) => {
        return valiResultModal(!!task.jumpLink, '请完成跳转链接任务配置')
      },
      mode: "custom", // 配置模式 fixed-固定配置 custom-B端配置
      unit: '体力',
      hasLink: true,
      defaultValue: {
        title: "", // 任务名称
        rateType: 1, // 任务类型 1永久｜2每日｜3永久限时｜4每日限时｜5无限制
        times: 2, // 每日上限
        jumpLink: '',
        reward: "" // 奖品值
      }
    },
    {
      name: '奖品配置',
      htmlType: "Title"
    },
    {
      name: "概率抽奖奖池", // 奖品名称
      filed: "RateTable",
      htmlType: "Award",
      required: true, // 是否必填
      validator: (value, formData) => {
        const error = rateTableValidator(value)
        return valiResultModal(!error, error)
      },
      prizeDataType: 1, // 发奖来源类型
      dialogType: "probability", // 类型 probability-概率出奖 unProbability-无概率出奖 rank-排行榜
      limit: 10, // 奖品配置上限
      conditionKeys: [], // 出奖条件
      defaultValue: [],
      dialogForm: [
        {
          name: "是否降级奖品",
          filed: "isBackUp",
          enum: [true, false],
          enumNames: ["是", "否"],
          mode: "fixed",
          defaultValue: false
        },
        {
          name: "奖品类型", // 名称
          filed: "type", // 字段
          enum: [1, 2, 3],
          mode: "fixed",
          enumNames: ["优惠券", "积分", "实物"], // 选择类组件，如select、radio
          defaultValue: 1
        },
        {
          name: "权益类型",
          filed: "benefitType",
          enum: [1, 2],
          mode: "fixed",
          enumNames: ["普通权益", "会员权益"],
          defaultValue: 1
        },
        {
          name: "权益隐藏id", // 名称
          filed: "ename", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            const { type, benefitType } = formData
            let status = true
            if (type === EQUITY_TYPE && benefitType === MEMBER_EQUITY && !value.trim()) status = false
            return valiResultModal(status, '请输入权益隐藏id')
          },
          placeholder: '请输入权益隐藏id',
          defaultValue: ''
        },
        {
          name: "奖品名称", // 名称
          filed: "name", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            let status = true
            if (!value) status = false
            return valiResultModal(status, '请完成奖品信息配置')
          },
          placeholder: '请输入奖品名称',
          defaultValue: ''
        },
        {
          name: "奖品图片",
          filed: "image",
          htmlType: "UploadImage",
          mode: "custom",
          required: true, // 是否必填
          validator: (value, formData) => {
            return valiResultModal(!!value, '请选择奖品图片')
          },
          imgWidth: 250, // 图片宽
          imgHeight: 250, // 图片高 htmlType为UploadImage配置
          defaultValue: ''
        },
        {
          name: "库存类型",
          filed: "switchStock",
          enum: [2, 1],
          mode: "fixed",
          enumNames: ["不限库存", "限制库存"],
          defaultValue: 2
        },
        {
          name: "奖品库存", // 名称
          filed: "stock", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            let status = true
            const { isBackUp } = formData
            if (!isBackUp) {
              const { switchStock, useStock } = formData
              const usePass = switchStock == STOCK_LIMIT ? +value >= (useStock || 0) : true
              const stockPass = switchStock == STOCK_LIMIT ? validateRangeNumber(value, [0, 99999]) : true
              if (!stockPass || !usePass) status = false
            }
            return valiResultModal(status, '奖品库存为0-99999之间的整数且大于发放库存')
          },
          placeholder: '请输入奖品库存',
          defaultValue: ''
        },
        {
          name: "积分价值", // 名称
          filed: "credits", // 字段
          required: true, // 是否必填
          mode: "fixed",
          validator: (value, formData) => {
            const { type } = formData
            let status = true
            if (type == CREDITS_TYPE && !validateRangeNumber(value, [0, 999])) status = false
            return valiResultModal(status, '请输入积分价值为0-999的整数')
          },
          placeholder: '请输入积分价值',
          defaultValue: ''
        },
        {
          name: "奖品描述", // 名称
          filed: "desc", // 字段
          placeholder: '请输入奖品描述',
          mode: "fixed",
          defaultValue: ''
        },
        {
          name: "使用链接", // 名称
          filed: "useUrl", // 字段
          mode: "fixed",
          validator: (value, formData) => {
            const { type } = formData
            let status = true, msg = ''
            if (type == EQUITY_TYPE && !!value && !urlCheck(value, passUrlList).status) {
              status = false
              msg = urlCheck(value, passUrlList).message
            }
            return valiResultModal(status, msg)
          },
          placeholder: '优惠券使用链接',
          defaultValue: ''
        },
        {
          name: "中奖概率", // 名称
          filed: "probability", // 字段
          required: true, // 是否必填
          mode: "fixed",
          validator: (value, formData) => {
            const { isBackUp } = formData
            let status = true
            if (!isBackUp && !validateRangeNumber(value, [0, 100], 2)) status = false
            return valiResultModal(status, '奖品概率必须大于0小于等于100且最多两位小数')
          },
          placeholder: '当前概率不能超过100',
          defaultValue: ''
        },
        {
          name: "商品查看链接", // 名称
          filed: "itemId", // 字段
          limit: 1,
          limit: 1,
          mode: "fixed",
          defaultValue: ''
        },
      ]
    },
    {
      name: "排行榜奖池", // 奖品名称
      filed: "RateTable1",
      htmlType: "Award",
      required: true, // 是否必填
      validator: (value) => {
        const error = rankTableValidator(value)
        return valiResultModal(!error, error)
      },
      prizeDataType: 2, // 发奖来源类型
      dialogType: "rank", // 类型 probability-概率出奖 unProbability-无概率出奖 rank-排行榜
      limit: 10, // 奖品配置上限
      conditionKeys: [], // 出奖条件
      defaultValue: [],
      dialogForm: [
        {
          name: "奖品类型", // 名称
          filed: "type", // 字段
          htmlType: "Select",
          enum: [1, 2, 3],
          mode: "fixed",
          enumNames: ["优惠券", "积分", "实物"], // 选择类组件，如select、radio
          defaultValue: 1
        },
        {
          name: "权益类型",
          filed: "benefitType",
          enum: [1, 2],
          mode: "fixed",
          enumNames: ["普通权益", "会员权益"],
          defaultValue: 1
        },
        {
          name: "权益隐藏id", // 名称
          filed: "ename", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            const { type, benefitType } = formData
            let status = true
            if (type === EQUITY_TYPE && benefitType === MEMBER_EQUITY && !value.trim()) status = false
            return valiResultModal(status, '请输入权益隐藏id')
          },
          placeholder: '请输入权益隐藏id',
          defaultValue: ''
        },
        {
          name: "奖品名称", // 名称
          filed: "name", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            let status = true
            if (!value) status = false
            return valiResultModal(status, '请完成奖品信息配置')
          },
          placeholder: '请输入奖品名称',
          defaultValue: ''
        },
        {
          name: "奖品图片",
          filed: "image",
          htmlType: "UploadImage",
          mode: "custom",
          required: true, // 是否必填
          validator: (value) => {
            return valiResultModal(!!value, '请选择奖品图片')
          },
          imgWidth: 250, // 图片宽
          imgHeight: 250, // 图片高 htmlType为UploadImage配置
          defaultValue: ''
        },
        {
          name: "积分价值", // 名称
          filed: "credits", // 字段
          required: true, // 是否必填
          mode: "fixed",
          validator: (value, formData) => {
            const { type } = formData
            let status = true
            if (type == CREDITS_TYPE && !validateRangeNumber(value, [0, 999])) status = false
            return valiResultModal(status, '请输入积分价值为0-999的整数')
          },
          placeholder: '请输入积分价值',
          defaultValue: ''
        },
        {
          name: "奖品描述", // 名称
          filed: "desc", // 字段
          placeholder: '请输入奖品描述',
          mode: "fixed",
          defaultValue: ''
        },
        {
          name: "使用链接", // 名称
          filed: "useUrl", // 字段
          mode: "fixed",
          validator: (value, formData) => {
            const { type } = formData
            let status = true, msg = ''
            // 如果奖品类型为优惠券，且值为true，校验url
            if (type == EQUITY_TYPE && !!value && !urlCheck(value, passUrlList).status) {
              status = false
              msg = urlCheck(value, passUrlList).message
            }
            return valiResultModal(status, msg)
          },
          placeholder: '优惠券使用链接',
          defaultValue: ''
        },
        {
          name: "领奖名次", // 名称
          filed: "rank", // 字段
          required: true, // 是否必填
          mode: "fixed",
          validator: (value) => {
            let status = true, msg = ''
            const rankArr = value.split("-");
            // 最大领奖名次限制
            const maxRankLimit = 50;
            const isRankPass = 
              rankArr.length == 2
              ? +rankArr[0] <= +rankArr[1]
              && /^[1-9]+[0-9]*$/.test(+rankArr[0])
              && /^[1-9]+[0-9]*$/.test(+rankArr[1])
              && isDot(rankArr[0])
              && isDot(rankArr[1])
              : false
            if (!isRankPass) {
              status = false
              msg = '请输入正确的领奖名次'
            } else if (rankArr[rankArr.length - 1] > maxRankLimit) {
              status = false
              msg = '请输入正确的领奖名次'
            }
            return valiResultModal(status, msg)
          },
          placeholder: '领奖名次, 第4名输入"4-4", 第5-10名输入"5-10',
          defaultValue: ''
        },
        {
          name: "商品查看链接", // 名称
          filed: "itemId", // 字段
          limit: 1,
          mode: "fixed",
          defaultValue: ''
        }
      ]
    },
    {
      name: "无概率奖池1", // 奖品名称
      filed: "RateTable2",
      htmlType: "Award",
      required: true, // 是否必填
      validator: (value, formData) => {
        const error = rateTableValidator(value)
        return valiResultModal(!error, error)
      },
      prizeDataType: 3, // 发奖来源类型
      dialogType: "unProbability", // 类型 probability-概率出奖 unProbability-无概率出奖 rank-排行榜
      limit: 10, // 奖品配置上限
      conditionKeys: [
        { key: 'cType', value: 1 }
      ], // 出奖条件
      defaultValue: [],
      dialogForm: [
        {
          name: "是否降级奖品",
          filed: "isBackUp",
          enum: [true, false],
          enumNames: ["是", "否"],
          mode: "fixed",
          defaultValue: false
        },
        {
          name: "奖品类型", // 名称
          filed: "type", // 字段
          enum: [1, 2, 3],
          mode: "fixed",
          enumNames: ["优惠券", "积分", "实物"], // 选择类组件，如select、radio
          defaultValue: 1
        },
        {
          name: "权益类型",
          filed: "benefitType",
          enum: [1, 2],
          mode: "fixed",
          enumNames: ["普通权益", "会员权益"],
          defaultValue: 1
        },
        {
          name: "权益隐藏id", // 名称
          filed: "ename", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            const { type, benefitType } = formData
            let status = true
            if (type === EQUITY_TYPE && benefitType === MEMBER_EQUITY && !value.trim()) status = false
            return valiResultModal(status, '请输入权益隐藏id')
          },
          placeholder: '请输入权益隐藏id',
          defaultValue: ''
        },
        {
          name: "奖品名称", // 名称
          filed: "name", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            let status = true
            if (!value) status = false
            return valiResultModal(status, '请完成奖品信息配置')
          },
          placeholder: '请输入奖品名称',
          defaultValue: ''
        },
        {
          name: "奖品图片",
          filed: "image",
          htmlType: "UploadImage",
          mode: "custom",
          required: true, // 是否必填
          validator: (value, formData) => {
            return valiResultModal(!!value, '请选择奖品图片')
          },
          imgWidth: 250, // 图片宽
          imgHeight: 250, // 图片高 htmlType为UploadImage配置
          defaultValue: ''
        },
        {
          name: "库存类型",
          filed: "switchStock",
          enum: [2, 1],
          mode: "fixed",
          enumNames: ["不限库存", "限制库存"],
          defaultValue: 2
        },
        {
          name: "奖品库存", // 名称
          filed: "stock", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            let status = true
            const { isBackUp } = formData
            if (!isBackUp) {
              const { switchStock, useStock } = formData
              const usePass = switchStock == STOCK_LIMIT ? +value >= (useStock || 0) : true
              const stockPass = switchStock == STOCK_LIMIT ? validateRangeNumber(value, [0, 99999]) : true
              if (!stockPass || !usePass) status = false
            }
            return valiResultModal(status, '奖品库存为0-99999之间的整数且大于发放库存')
          },
          placeholder: '请输入奖品库存',
          defaultValue: ''
        },
        {
          name: "积分价值", // 名称
          filed: "credits", // 字段
          required: true, // 是否必填
          mode: "fixed",
          validator: (value, formData) => {
            const { type } = formData
            let status = true
            if (type == CREDITS_TYPE && !validateRangeNumber(value, [0, 999])) status = false
            return valiResultModal(status, '请输入积分价值为0-999的整数')
          },
          placeholder: '请输入积分价值',
          defaultValue: ''
        },
        {
          name: "奖品描述", // 名称
          filed: "desc", // 字段
          placeholder: '请输入奖品描述',
          mode: "fixed",
          defaultValue: ''
        },
        {
          name: "使用链接", // 名称
          filed: "useUrl", // 字段
          mode: "fixed",
          validator: (value, formData) => {
            const { type } = formData
            let status = true, msg = ''
            if (type == EQUITY_TYPE && !!value && !urlCheck(value, passUrlList).status) {
              status = false
              msg = urlCheck(value, passUrlList).message
            }
            return valiResultModal(status, msg)
          },
          placeholder: '优惠券使用链接',
          defaultValue: ''
        },
        {
          name: "商品查看链接", // 名称
          filed: "itemId", // 字段
          limit: 1,
          limit: 1,
          mode: "fixed",
          defaultValue: ''
        },
      ]
    },
    {
      name: "无概率奖池2", // 奖品名称
      filed: "RateTable3",
      htmlType: "Award",
      required: true, // 是否必填
      validator: (value, formData) => {
        const error = rateTableValidator(value)
        return valiResultModal(!error, error)
      },
      prizeDataType: 3, // 发奖来源类型
      dialogType: "unProbability", // 类型 probability-概率出奖 unProbability-无概率出奖 rank-排行榜
      limit: 10, // 奖品配置上限
      conditionKeys: [
        { key: 'cType', value: 2 }
      ], // 出奖条件
      defaultValue: [],
      dialogForm: [
        {
          name: "是否降级奖品",
          filed: "isBackUp",
          enum: [true, false],
          enumNames: ["是", "否"],
          mode: "fixed",
          defaultValue: false
        },
        {
          name: "奖品类型", // 名称
          filed: "type", // 字段
          enum: [1, 2, 3],
          mode: "fixed",
          enumNames: ["优惠券", "积分", "实物"], // 选择类组件，如select、radio
          defaultValue: 1
        },
        {
          name: "权益类型",
          filed: "benefitType",
          enum: [1, 2],
          mode: "fixed",
          enumNames: ["普通权益", "会员权益"],
          defaultValue: 1
        },
        {
          name: "权益隐藏id", // 名称
          filed: "ename", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            const { type, benefitType } = formData
            let status = true
            if (type === EQUITY_TYPE && benefitType === MEMBER_EQUITY && !value.trim()) status = false
            return valiResultModal(status, '请输入权益隐藏id')
          },
          placeholder: '请输入权益隐藏id',
          defaultValue: ''
        },
        {
          name: "奖品名称", // 名称
          filed: "name", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            let status = true
            if (!value) status = false
            return valiResultModal(status, '请完成奖品信息配置')
          },
          placeholder: '请输入奖品名称',
          defaultValue: ''
        },
        {
          name: "奖品图片",
          filed: "image",
          htmlType: "UploadImage",
          mode: "custom",
          required: true, // 是否必填
          validator: (value, formData) => {
            return valiResultModal(!!value, '请选择奖品图片')
          },
          imgWidth: 250, // 图片宽
          imgHeight: 250, // 图片高 htmlType为UploadImage配置
          defaultValue: ''
        },
        {
          name: "库存类型",
          filed: "switchStock",
          enum: [2, 1],
          mode: "fixed",
          enumNames: ["不限库存", "限制库存"],
          defaultValue: 2
        },
        {
          name: "奖品库存", // 名称
          filed: "stock", // 字段
          mode: "fixed",
          required: true, // 是否必填
          validator: (value, formData) => {
            let status = true
            const { isBackUp } = formData
            if (!isBackUp) {
              const { switchStock, useStock } = formData
              const usePass = switchStock == STOCK_LIMIT ? +value >= (useStock || 0) : true
              const stockPass = switchStock == STOCK_LIMIT ? validateRangeNumber(value, [0, 99999]) : true
              if (!stockPass || !usePass) status = false
            }
            return valiResultModal(status, '奖品库存为0-99999之间的整数且大于发放库存')
          },
          placeholder: '请输入奖品库存',
          defaultValue: ''
        },
        {
          name: "积分价值", // 名称
          filed: "credits", // 字段
          required: true, // 是否必填
          mode: "fixed",
          validator: (value, formData) => {
            const { type } = formData
            let status = true
            if (type == CREDITS_TYPE && !validateRangeNumber(value, [0, 999])) status = false
            return valiResultModal(status, '请输入积分价值为0-999的整数')
          },
          placeholder: '请输入积分价值',
          defaultValue: ''
        },
        {
          name: "奖品描述", // 名称
          filed: "desc", // 字段
          placeholder: '请输入奖品描述',
          mode: "fixed",
          defaultValue: ''
        },
        {
          name: "使用链接", // 名称
          filed: "useUrl", // 字段
          mode: "fixed",
          validator: (value, formData) => {
            const { type } = formData
            let status = true, msg = ''
            if (type == EQUITY_TYPE && !!value && !urlCheck(value, passUrlList).status) {
              status = false
              msg = urlCheck(value, passUrlList).message
            }
            return valiResultModal(status, msg)
          },
          placeholder: '优惠券使用链接',
          defaultValue: ''
        },
        {
          name: "商品查看链接", // 名称
          filed: "itemId", // 字段
          limit: 1,
          limit: 1,
          mode: "fixed",
          defaultValue: ''
        },
      ]
    }
  ],
}

module.exports = projectData