import dayjs from 'dayjs';
const {
  cloud
} = getApp();
const {
  function: fc
} = cloud;
import { getStatTotalData, getStatJoinData, getStatTaskDataData, getStatItemData } from '../../../api';
Component({
  mixins: [],
  data: {
    userJoinData: [],
    userTaskData: [],
    openPrizeData: [],
    taskData: [],
    accumulateData: [
      [{
        name: '活动打开次数',
        type: 'totalOpenCount',
        num: 0
      }, {
        name: '新增关注数',
        type: 'newAttentionStoreCount',
        num: 0
      }],
      [{
        name: '活动参与次数',
        type: 'totalJoinCount',
        num: 0
      }, {
        name: '商品曝光数量',
        type: 'itemShowCount',
        num: 0
      }],
      [{
        name: '新增会员数',
        type: 'newMemberCount',
        num: 0
      }]
    ]
  },
  props: {},
  didMount() {
    let {
      id
    } = this.$page.$router.params;
    // my.showLoading()
    this.getAccumulateData(id);
    this.getUserJoinData(id);
    this.getTaskData(id);
    this.getOpenPrizeData(id);
  },
  didUpdate() {},
  didUnmount() {},
  methods: {
    invokeFn(name, params, handler) {
      return new Promise((resolve, reject) => {
        fc.invoke(name, params, handler).then(res => {
          if (res.success) {
            resolve(res.data);
          } else {
            this.showFailToast(res.message);
          }
        }).catch(err => {
          reject(err);
        });
      });
    },
    async getOpenPrizeData(id) {
      const { data, message, success } = await getStatItemData({ activityId: id });
      if(success) {
        this.setData({
          openPrizeData: Object.keys(data).map(v => {
            return {
              ...data[v],
              date: v
            };
          })
        });
      }
    },
    async getAccumulateData(id) {
      const { data, success, message } = await getStatTotalData({ activityId: id });
      if(success) {
        const { totalOpenCount, newAttentionStoreCount, totalJoinCount, itemShowCount, newMemberCount } = data;
        this.setData({
          accumulateData: [
            [{
              name: '活动打开次数',
              type: 'totalOpenCount',
              num: totalOpenCount
            }, {
              name: '新增关注数',
              type: 'newAttentionStoreCount',
              num: newAttentionStoreCount
            }],
            [{
              name: '活动参与次数',
              type: 'totalJoinCount',
              num: totalJoinCount
            }, {
              name: '商品曝光数量',
              type: 'itemShowCount',
              num: itemShowCount
            }],
            [{
              name: '新增会员数',
              type: 'newMemberCount',
              num: newMemberCount
            }]
          ]
        });
      }
    },
    goToActivityList() {
      this.$page.$router.push('/activity/list');
    },
    showFailToast(content) {
      my.showToast({
        type: 'fail',
        content: content
      });
    },
    async getUserJoinData(id) {
      const { data, success, message } = await getStatJoinData({ activityId: id });
      if(success) {
        this.setData({
          userJoinData: Object.keys(data).map(v => {
            return {
              ...data[v],
              date: v
            };
          })
        });
      }
      // this.invokeFn('duiba', {
      //   activityOutId: id
      // }, 'backstage.reportData.userJoinData').then(data => {
      //   this.setData({
      //     userJoinData: data
      //   })
      // })
    },
    async getTaskData(id, type = 'groupInvite') {
      const { data, message, success } = await getStatTaskDataData({ activityId: id });
      if(success) {
        this.setData({
          userTaskData: Object.keys(data).map(v => {
            return {
              ...data[v],
              date: v
            };
          })
        });
      }

    }
  },
});