import { rankTableValidator, validateRangeNumber, rankTimeValidator, isNumber,validatePositiveInteger,validateInteger,urlChecks, rateTableValidator  } from "../../../utils/validate";

// 使用 async-validator 校验
// 文档地址: https://github.com/yiminghe/async-validator

export const descriptor = {
  
  title: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value && value.length <= 12;
    },
    message: "请输入正确的活动名称"
  },      
  
  timeRange: {
    required: true,
    validator: (rule, value) => {
      return !!value.every(v => !!v);
    },
    message: "请输入正确的活动时间"
  },    
  
  subtitle: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value && value.length <= 16;
    },
    message: "请输入正确的活动副标题"
  },    
  
  rule: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: '请输入活动规则'
  },    
  
  RateTable: { required: true, validator: rateTableValidator },
  RateTable_copy1: { required: true, validator: rateTableValidator },
  RankTable: { required: true, validator: rankTableValidator },
  
  textarea: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: '请输入文本域'
  },  
  
  timeRange: {
    required: true,
    validator: (rule, value) => {
      return !!value.every(v => !!v);
    },
    message: "请选择正确时间"
  },
  
  tasks: {
    type: 'object',
    required: false,
    fields: {
      
      follow: {
        validator: (rule, val) => {
          return !!(val.title);
        },
        message: '请设置关注店铺任务'
      },
      sign: {
        validator: (rule, val) => {
          return !!(val.title);
        },
        message: '请设置签到奖励任务'
      },
      member: {
        validator: (rule, val) => {
          return !!(val.title);
        },
        message: '请设置加入会员任务'
      },
      jumpLink: {
        required: true,
        validator: (rule, val, cb, source) => {
          return !!val.link;
        },
        message: '请完善跳转任务任务'
      },
      invites: {
        validator: (rule, val) => {
          return !!(val.title);
        },
        message: '请设置邀请好友任务'
      },
      collectGoods: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请完善收藏商品任务'
      },
      browseGoods: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请完善浏览商品任务'
      },
      orderGoods: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请完善下单商品任务'
      },
      
      task1: {
        validator: (rule, val) => {
          return !!(val.title);
        },
        message: '请设置自定义任务任务'
      },
      task2: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请完善自定义选择商品任务任务'
      },
    }
  },
  
  customConfig:{
    type:'object',
    required: false,
    fields:{
        
      input: {
        required: true,
        validator: (rule, value) => {
          return !!isNumber(value);
        },
        message: "请输入正确的输入框"
      },input1: {
        required: true,
        validator: (rule, value) => {
          value = value.trim();
          return !!value;
        },
        message: '请输入前后带文字输入框'
      },
      uploadImg: {
        required: true,
        validator: (rule, value) => {
          value = value.trim();
          return !!value;
        },
        message: "请上传上传图片图片"
      }
    }
  },
};

export const formatValidator = (descriptor, validators) => {
  validators = validators || {};
  Object.keys(descriptor).forEach(key => {
    if(descriptor[key].fields) {
      Object.keys(descriptor[key].fields).forEach(fieldKey => {
        validators[`${key}.${fieldKey}`] = {
          status: 'success',
          message: ''
        };
      });
    } else {
      validators[key] = {
        status: 'success',
        message: ''
      };
    }
    
  });
  return validators;
};