import { cloneForce } from '@jsmini/clone';
import { methods } from '../../../mixins/mixins';
import { activityAddData, appName } from '../../../project.data'
import { getFormInfo, formatFormData, parsingFormData } from '../../../utils/formData'

import {
  getActivityDetail,
  saveActivityInfo,
} from '/api';
import {
  addFloat,setPrizeProbalityRange,throttleHandle
} from '/utils/helper';

const THANKS_TYPE = 5;

Component({
  mixins: [ methods ],
  data: {
    originData: cloneForce(activityAddData),
    appName,
    labelCol: { fixedSpan: 5 },
    id: '',
    isEnd: false,
    isStart: false,
    originalStartTime: '',
    formData: {},
    formState: {},
    isPostParams: true
  },
  onInit() {
    const { formData, formState } = getFormInfo(activityAddData)
    this.setData({
      formData,
      formState
    })
  },
  didMount() {
    const { id } = this.$page.$router.params;
    id && this.getActivityInfo(id);
  },
  methods: {
    // 获取activityId活动信息
    async getActivityInfo(activityId) {
      try {
        const { success, data, message } = await getActivityDetail({ activityId});
        if (!success) {
          this.showFailToast(message);
          return;
        }
        const parsingData = parsingFormData(data)
        this.setData({
          formData: {
            ...this.data.formData,
            ...parsingData,
            timeRange: [parsingData.startTime, parsingData.endTime]
          },
          originalStartTime: +data.startTime,
          isStart: +data.startTime < Date.now(),
          isEnd: +data.endTime < Date.now(),
          tasks: data.tasks
        });

      } catch (error) {
        console.log(error, 'err');
      }
    },
    // 提交信息
    onSubmit: throttleHandle(async function() {
      my.showLoading();

      const isValidForm = this.validateForm();
      if (!isValidForm){
        my.hideLoading();
        return;
      } 
      const params = this.formatActivityParams();
      params.timeRange && delete params.timeRange
      console.log('最后提交的数据', params);

      if (this.data.isPostParams) {
        this.setData({
          isPostParams: false
        });
        setTimeout(() => {
          this.setData({
            isPostParams: true
          });
        }, 2000);
        const { success, message } = await saveActivityInfo(params);
        my.hideLoading();
        if (success) {
          this.backList();
          my.hideLoading();
        } else {
          this.showFailToast(message);
        }
      } else {
        my.hideLoading();
      }
    }, 1000),
    showFailToast(text) {
      my.showToast({
        type: 'fail',
        content: text
      });
    },
    // 格式化参数
    formatActivityParams() {
      const {
        formData,
        originData
      } = this.data;
      const formatData = formatFormData(formData)
    
      // 处理奖品数据
      let prizeList = [];
      for (let key in formatData) {
        const filedItem = originData.find(v => v.filed === key && v.htmlType === 'Award')
        if (!!filedItem) {
          prizeList = [...prizeList,...setPrizeProbalityRange(formatData[key])]
          delete formatData[key]
        }
      }
      
      return {
        ...formatData,
        prizeList,
        startTime: formatData.timeRange ? formatData.timeRange[0] : 0,
        endTime: formatData.timeRange ? formatData.timeRange[1] : 0
      };
    },
    // 补足谢谢参与类型
    formatPrizeList(prizeInfoList = []) {
      let totalPercent = prizeInfoList.reduce((total, next) => {
        return total = addFloat(total, +next.probability);
      }, 0);
      // 排名类型不含谢谢参与
      if (prizeInfoList[0].rank) return prizeInfoList;
      let prizeInfoListCopy = prizeInfoList.concat().map((v, index) => ({
        ...v,
        level: index
      }));

      if (totalPercent < 100) {
        let thanksType = {
          type: THANKS_TYPE,
          name: '谢谢参与',
          probability: 100 - totalPercent
        };
        prizeInfoListCopy.push(thanksType);
      }
      return prizeInfoListCopy;
    },
    // 任务配置选择商品回调
    onItemIdsChange(ids, dataName) {
      this.setData({
        tasks: {
          ...this.data.tasks,
          [dataName]: {
            ...this.data.tasks[dataName],
            itemIds: ids
          }
        },
      });
    },
    backList() {
      this.$page.$router.go(-1);
    }
  },
});
