export const methods = {
  methods: {
    // 根据dataName  改变值
    onInputChangeByDataName(e) {
      const { name } = e.target.dataset;
      const { value } = e.detail;
      this.resetStock && this.resetStock(value, name);
      this.setDataByKey(value, name);
    },
    onChangeByDataName(val, key) {
      this.setDataByKey(val, key);
    },
    onTimeChange(timeRange, error, timeKeys, key) {
      const valiRes = {
        status: error ? 'error' : 'success',
        message: error || ''
      }
      this.setDataByKey(timeRange, key, valiRes);
    },
    /**
    * 根据key值改变数据, 支持key  a/a.b/a.b.c的形式
    * @param {*} val
    * @param {string} key
    */
    setDataByKey(val, key, coutomValiRes) {
      const { formData, formState, originData } = this.data
      // 判断表单元素是否需要校验
      const filedItem = originData.find(v => v.filed === key)
      let filedState = formState[key]
      if (filedItem && filedItem.validator) {
        const valiRes = filedItem.validator(val, formData)
        filedState = !!coutomValiRes && valiRes.status ? coutomValiRes : valiRes
      }
      this.setData({
        formData: {
          ...formData,
          [key]: val
        },
        formState: {
          ...formState,
          [key]: filedState
        }
      });
    },
    // 校验form数据
    validateForm() {
      const { originData, formData, formState } = this.data
      let isThrouth = true
      for (let item of originData) {
        // 如果需要校验
        if (item.validator) {
          const filedValue = formData[item.filed]
          const valiRes = item.validator(filedValue, formData)
          // 校验不通过
          if (!valiRes.status) isThrouth = false
          formState[item.filed] = valiRes
        }
      }
      this.setData({
        formState
      });
      return isThrouth
    }
  }
};