import dayjs from "dayjs";
import { activityList } from '../../../project.data'

import {
  getActivityList,
  delActivity,
  createCopyActivity
} from "/api";
import { appId, env } from "/config";
import { setClipboard } from "/utils";

Component({
  data: {
    env,
    dataBoardBtnShowEnv: activityList.dataBoardBtnShowEnv,
    isLoadingList: false,
    exportDialogVisible: false,
    exportLinkUrl: '',
    dataSource: [],
    confirmDialog: {
      visible: false,
      content: "删除活动后该活动用户参与信息将全部删除，确认删除吗？",
    },
    pageInfo: {
      pageNo: 1,
      pgaeSize: 10,
      total: 0
    },
    deleteId: "",
    winnerListDialogVisible: false,
    statisticDialogVisible: false,
    selectedItem: {}
  },
  props: {
    buttons: ['edit', 'export', 'delete', 'copyLink']
  },
  didMount() {
    this.getList();
  },
  methods: {
    /**
     *获取活动列表
     *
     * @param {number} [currentPage=1] 页数
     * @param {number} [size=10] 页码尺寸
     * @returns {void}
     */
    async getList(currentPage = 1, size = 10) {
      this.setData({ isLoadingList: true });
      try {
        const { success, data, message } = await getActivityList({
          pageNo: currentPage,
          pageSize: size,
        });
        this.setData({ isLoadingList: false });

        if (!success) {
          my.showToast({
            type: "fail",
            content: message,
          });
          return;
        }

        const { list, pageNo, pageSize, total } = data;

        const timeNow = new Date().getTime();
        let formatList = list.map((i) => {
          return {
            ...i,
            isEnd: +i.endTime < Date.now(),
            isStart: +i.startTime < Date.now(),
            startTime: dayjs(+i.startTime).format("YYYY-MM-DD HH:mm:ss"),
            endTime: dayjs(+i.endTime).format("YYYY-MM-DD HH:mm:ss"),
          };
        });

        this.setData({
          dataSource: formatList,
          pageInfo: {
            pageNo,
            pageSize,
            total,
          },
        });
      } catch (error) {
        this.setData({
          isLoadingList: false,
        });
      }
    },
    // 获取中奖名单
    handleOpenWinnerList(evt) {
      this.setData({
        winnerListDialogVisible: true,
        selectedItem: evt.target.dataset.x.record
      });
    },
    onCloseWinnerListDialog() {
      this.setData({
        winnerListDialogVisible: false
      });
    },
    // 展示复制链接弹框
    showExportDialog(data) {
      console.log('展示复制链接弹框', data);
      this.setData({
        exportDialogVisible: true,
        exportLinkUrl: data.exportLinkUrl
      });
    },

    // 复制链接
    async onCopyLink(evt) {
      const { activityId } = evt.target.dataset.x.record;
      let text = `https://m.duanqu.com/?_ariver_appid=${appId}&query=activityId%3D${activityId}`;
      try {
        await setClipboard({
          text
        });
        my.showToast({
          type: "success",
          content: "复制活动链接成功",
        });
      } catch (error) {
        console.log(error);
      }
    },
    onCloseExportDialog() {
      this.setData({
        exportDialogVisible: false
      });
    },
    // 复制新活动
    async onCreateNewActivity(evt) {
      const { activityId } = evt.target.dataset.x.record;
      let res = await createCopyActivity({ activityId });
      if (res.success) {
        this.getList();
      } else {
        my.showToast({
          content: res.message,
          type: "fail",
        });
      }
    },
    toDataPage(evt) {
      const { activityId } = evt.target.dataset.x.record;
      this.$page.$router.push(`/activity/data/${activityId}`);
    },
    // 点击列表删除
    handleTapDelete(evt) {
      const { activityId } = evt.target.dataset.x.record;
      console.log(1);
      this.setData({
        confirmDialog: Object.assign({}, this.data.confirmDialog, {
          visible: true,
        }),
        deleteId: activityId,
      });
    },
    onCloseConfirmDialog() {
      this.setData({
        confirmDialog: Object.assign({}, this.data.confirmDialog, {
          visible: false,
        }),
      });
    },
    onConfirmDelete() {
      const activityId = this.data.deleteId;

      this.setData({
        confirmDialog: Object.assign({}, this.data.confirmDialog, {
          visible: false,
        }),
      });

      activityId && this.deleteActivityFromId(activityId);
    },
    // 删除活动
    async deleteActivityFromId(activityId) {
      try {
        const { success, message } = await delActivity({
          activityId
        });
        if (success) {
          this.getList();
        } else {
          my.showToast({
            type: "fail",
            content: message,
          });
        }
      } catch (error) {
        console.log(error);
      }
    },
    // 编辑
    handleClickEdit(evt) {
      let { activityId } = evt.target.dataset.x.record;
      this.$page.$router.push(`/activity/edit/${activityId}`);
    },
    changePagination(evt) {
      const { value } = evt.detail;
      this.getList(value);
    },
    // 关闭数据需求弹窗
    onCloseStatisticDialog() {
      this.setData({
        statisticDialogVisible: false
      });
    },
    // 导出数据需求
    async onExportStatistics(evt) {
      this.setData({
        statisticDialogVisible: true,
        selectedItem: evt.target.dataset.x.record
      });
    },
    // 数据看板
    onShowDataBoard(evt) {
      this.setData({
        dataBoardDialogVisible: true,
        selectedItem: evt.target.dataset.x.record
      });
    },
    onCloseDataBoardDialog() {
      this.setData({
        dataBoardDialogVisible: false
      });
    },
  },
});
