import { chooseImage, getImageInfo, getFileInfo } from "/utils";
const { cloud } = getApp();
const { function: fc } = cloud;

Component({
  mixins: [],
  data: {
    isError: false
  },
  props: {
    imageLimit: [250, 250],
    onSuccess: () => {},
    onError: () => {},
    url: '',
    dataName: ''
  },
  didMount() {},
  didUpdate() {},
  didUnmount() {},
  methods: {
    async uploadImage() {
      const { onSuccess, onError, dataName, imageLimit } = this.props;
      try {
        const res = await chooseImage();

        if (!res.apFilePaths.length) return;

        const { height, width, type, path } = await getImageInfo({
          src: res.apFilePaths[0],
        });

        let imgBool = ~path.indexOf(".png") || ~path.indexOf(".jpg");
        if (height !== imageLimit[1] || width !== imageLimit[0] || !imgBool) {
          my.showToast({
            type: 'fail',
            content: `请上传${imageLimit[0]}宽、${imageLimit[1]}高的图片`
          })
          return;
        }

        const fileInfo = await getFileInfo({ apFilePath: res.apFilePaths[0] });
        const { size } = fileInfo;
        const maxByte = 3 * 1024 * 1024;
        if (size > maxByte) {
          my.showToast({
            type: 'fail',
            content: '图片大小不能超过3M'
          })
          return;
        }

        const { url } = await cloud.file.uploadFile({
          filePath: res.apFilePaths[0],
          fileType: "image",
          fileName: path.split("/").pop(),
        });

        onSuccess && onSuccess(url, dataName);
      } catch (error) {
        onError({}, error);
      }
    },
  },
});
