import { uploadDataCreateFile } from '/api';

Component({
  mixins: [],
  data: {},
  props: {
    visible: false,
    onClose: () => {},
    list: [],
    selectedItem: {}
  },
  didMount() {},
  didUpdate() {},
  didUnmount() {},
  methods: {
    closeDialog() {
      this.props.onClose();
    },
    // 导出中奖名单
    async exportWinnerList() {
      const { activityId, title } = this.props.selectedItem;
      my.showLoading({
        content: '生成文件中...'
      });
      try {
        const { success, data, message } = await uploadDataCreateFile({
          activityId,
          title
        });
        my.hideLoading();
        
        if(success) {
          my.setClipboard({
            text: data.url.replace(/amp;/g, ''),
            success(res) {
              my.showToast({
                type: 'success',
                content: '下载链接复制成功,请在浏览器中打开下载'
              });
            }
          });
        } else {
          my.showToast({
            type: 'fail',
            content: message
          });
        }
      } catch (error) {
        my.hideLoading();
        console.log(error, 'exportList-error');
      }

    }
  },
});
