import { passUrlList, urlCheck } from "../../../utils/helper";

import { validateRangeNumber } from "../../../utils/validate";

Component({
  mixins: [],
  data: {
    dataSource:[
      { label: 1, value: 1 },
      { label: 2, value: 2 },
      { label: 3, value: 3 },
      { label: 4, value: 4 },
      { label: 5, value:5 },
      { label: 6, value:6 },
      { label: 7, value:7 },
      { label: 8, value:8 },
      { label: 9, value:9 },
      { label: 10, value:10 },
    ],
    rateType: 1,
    times: '',
    title: '',
    jumpLink: '',
    itemIds: '',
    reward: ''
  },
  props: {
    visible: false,
    hasLink: false,
    hasItems: false,
    type: '',
    unit: '',
    frequency:'',
    taskData: {
      title: '',
      rateType: 1,
      times: '',
      reward: '',
      itemIds: ''
    },
    onClose: () => {},
    onUpdate: () => {}
  },
  didMount() {
    this.initData();
  },
  didUpdate() {},
  didUnmount() {},
  methods: {
    initData() {
      Object.keys(this.props.taskData).forEach(key => {
        this.setData({
          [key]: this.props.taskData[key]
        });
      });
    },
    onCloseDialog() {
      this.props.onClose();
    },
    onTimesChange(e) {
      const { value } = e.detail;
      this.setData({
        times: value
      });
    },
    onItemIdsChange(ids) {
      this.setData({
        itemIds:ids
      });
    },
    onrateTypeChange(e) {
      const { value } = e.detail;
      this.setData({
        rateType: value
      });
    },
    onChange(e) {
      const { value } = e.detail;
      const { name } = e.target.dataset;
      this.setData({
        [name]: value
      });
    },
    onSaveTask() {
      const { title, jumpLink, reward, rateType, times, itemIds } = this.data;
      if(!title.trim()) {
        my.showToast({
          type: 'fail',
          content: '请输入任务标题'
        });
        return;
      }

      if (this.props.hasLink && !urlCheck(jumpLink, passUrlList).status) {
        my.showToast({
          type: 'fail',
          content:  urlCheck(jumpLink, passUrlList).message
        });
        return;
      }

      if(this.props.hasItems && !itemIds) {
        my.showToast({
          type: 'fail',
          content: '请输入选择商品'
        });
        return;
      }

      if(!reward || !validateRangeNumber(reward, [1, 999])) {
        my.showToast({
          type: 'fail',
          content: '请输入正确的任务奖励'
        });
        return;
      }

      let taskData = { ...this.props.taskData, title, jumpLink, reward, rateType, times, itemIds, type: this.props.type };

      this.props.onUpdate && this.props.onUpdate(taskData);

      this.onCloseDialog();
    }
  },
});
