import { getStats } from '/api';

Component({
  mixins: [],
  data: {
    // 数据统计开始结束时间
    timeRange: []
  },
  props: {
    onClose: () => { },
    onShowExportDialog: () => { },
    selectedItem: {}
  },
  didMount() {
  },
  methods: {
    // 关闭弹窗
    onCloseDialog() {
      this.setData({
        startDay: '',
        endDay: ''
      });
      this.props.onClose && this.props.onClose();
    },
    // 监听时间变化
    handleTimeRangeChange(e) {
      console.log(e.detail.value);
      const [startTime, endTime] = e.detail.value;
      this.setData({
        timeRange: [startTime, endTime]
      });
    },
    // 导出
    async handleExport(evt) {
      console.log(this.props);
      // 未选择任何条件搜索
      if (!this.data.timeRange.length && !this.data.timeRange[0] && !this.data.timeRange[1]) {
        my.showToast({
          type: 'fail',
          content: '请选择统计时间范围'
        });
        return;
      }
      const { activityId } = this.props.selectedItem;
      let params = { 
        activityId, 
        startDay: this.data.timeRange[0],
        endDay: this.data.timeRange[1]
      };
      my.showLoading({
        content: '生成文件中...'
      });
      try {
        let { success, data, message } = (await getStats(params)) || {};
        console.log(success, data, message, '复制链接');
        if (success) {
          this.props.onShowExportDialog({
            exportLinkUrl: data.url.replace(/amp;/g, '')
          });
          console.log(data, '下载链接');
        } else {
          my.showToast({
            type: 'fail',
            content: message
          });
        }

        my.hideLoading();
      } catch (error) {
        my.hideLoading();
        console.log(error, 'exportStatistics-error');
      }
    }
  }
});
