import { activityList } from '../../../project.data'
import { findWinnerInfoList, exportAwardsList } from '/api';
import dayjs from 'dayjs';
const { isLogistics, filters, prizeTypes, prizeDataTypes, tableData, prizeTypesObj, prizeDataTypesObj } = activityList.winnerDialog

Component({
  mixins: [],
  data: {
    isLogistics,
    filters,
    prizeTypes,
    prizeDataTypes,
    tableData,
    prizeTypesObj,
    prizeDataTypesObj,
    // 搜索条件
    searchInfo: {
      pageNo: 1,
      pageSize: 10,
      prizeId: null,
      userNick: null,
      timeRange: [],
      shipStatus: null,
      prizeType: null,
      prizeDataType: null,
    },
    list: [],
    total: 0,
    isLoading: false,
    showShip: false,
    winactivityId: '',
  },
  props: {
    onClose: () => { },
    onShowExportDialog: () => { },
    selectedItem: {}
  },
  methods: {
    // 更换页码时调用接口
    handleChangePage(e) {
      const { value } = e.detail;
      this.setData({
        'searchInfo.pageNo': value
      });
      this.searchList();
    },
    // 搜索
    async handleSearch() {
      if (!this.valiSearchData()) return
      this.setData({
        'searchInfo.pageNo': 1
      });
      this.searchList();
    },
    // start《条件搜索》初始化数据更新
    resetData() {
      this.setData({
        searchInfo: {
          pageNo: 1,
          pageSize: 10,
          prizeId: null,
          userNick: null,
          timeRange: [],
          shipStatus: null,
          prizeType: null,
          prizeDataType: null,
        },
        list: [],
        total: 0,
        isLoading: false,
        showShip: false,
        winactivityId: ''
      });
    },
    onCloseDialog() {
      this.resetData();
      this.props.onClose && this.props.onClose();
    },

    // 监听input改变
    handleInputChange(e) {
      const { value } = e.detail;
      const { name } = e.target.dataset;
      this.setData({
        [`searchInfo.${name}`]: value
      });
    },
    // 监听发奖时间变化
    handleTimeRangeChange(e) {
      const [startTime, endTime] = e.detail.value;
      this.setData({
        'searchInfo.timeRange': [startTime, endTime]
      });
    },
    // 搜索
    async searchList() {
      const searchData = this.formatSearchData()
      const params = {
        ...searchData,
        activityId: this.props.selectedItem.activityId
      }

      console.log('搜索参数', params);

      try {
        this.setData({
          isLoading: true
        });
        const { data, success } = (await findWinnerInfoList(params)) || {};
        const { list, total } = data;
        console.log(data, 'data-----');
        list.map(v => {
          v.createTime = dayjs(+v.createTime).format('YYYY-MM-DD HH:mm:ss');
          v.receiveTime = dayjs(+v.receiveTime).format('YYYY-MM-DD HH:mm:ss');
        });
        if (success) {
          this.setData({
            list,
            total
          });
          this.setData({
            isLoading: false
          });
        }
      } catch (error) {
        this.setData({
          isLoading: false
        });
      }
    },
    // 导出数据
    async handleExport(evt) {
      if (!this.valiSearchData()) return
      
      const { activityId, title } = this.props.selectedItem;
      const searchData = this.formatSearchData()
      const params = {
        ...searchData,
        activityId,
        pageNo: 1,
        pageSize: 500
      };
      my.showLoading({
        content: '生成文件中...'
      });
      try {
        let { success, data, message } = (await exportAwardsList({ title, ...params })) || {};
        console.log(success, data, message, '复制链接');
        if (success) {
          this.props.onShowExportDialog({
            exportLinkUrl: data.url.replace(/amp;/g, '')
          });
          console.log(data, '下载链接');
        } else {
          my.showToast({
            type: 'fail',
            content: message
          });
        }

        my.hideLoading();
      } catch (error) {
        my.hideLoading();
        console.log(error, 'exportList-error');
      }
    },
    // 导入发货信息
    handleImport() {
      const { activityId } = this.props.selectedItem;
      this.setData({
        showShip: true,
        winactivityId: activityId
      });
      console.log('winner====showShip', this.data.showShip);
    },
    // 关闭导入发货窗口
    handleShipClose() {
      this.setData({
        showShip: false,
        winactivityId: ''
      });
    },
    // 校验搜索
    valiSearchData() {
      // 未选择任何条件搜索
      const {
        prizeId,
        userNick,
        timeRange,
        shipStatus,
        prizeType,
        prizeDataType,
      } = this.data.searchInfo;
      
      if (
        !prizeId &&
        !userNick &&
        !timeRange.length &&
        shipStatus == null &&
        prizeType == null &&
        prizeDataType == null 
      ) {
        this.resetData();
        my.showToast({
          type: 'fail',
          content: '请填写至少一个筛选信息'
        });
        return false
      } 
      return true
    },
    // 处理搜索数据
    formatSearchData() {
      const { searchInfo, filters } = this.data
      const searchData = {}
      for (let key of filters) {
        if (key === 'timeRange') {
          searchData.startTime = searchInfo.timeRange[0] ? new Date(searchInfo.timeRange[0]).getTime() : null;
          searchData.endTime = searchInfo.timeRange[1] ? new Date(searchInfo.timeRange[1]).getTime() : null;
        } else {
          searchData[key] = searchInfo[key]
        }
      }
      return searchData
    }
  }
});
