const { cloud } = getApp();
const { function: fc } = cloud;
const plugin = requirePlugin("myPlugin");
import { bizCode } from "/config";
import { queryBenefitByEname } from "/api";
import { cloneForce } from '@jsmini/clone';
import { getFormInfo, formatFormData, parsingFormData } from '../../../utils/formData'
import { methods } from '../../../mixins/mixins';
import { AWARD_TYPE, BENEFIT_TYPE, STOCK_TYPE } from '../../../constant'

const { EQUITY_TYPE, CREDITS_TYPE, OBJECT_TYPE, LOWER_TYPE } = AWARD_TYPE
const { SIMPLE_EQUITY, MEMBER_EQUITY } = BENEFIT_TYPE
const { STOCK_LIMIT, STOCK_NO_LIMIT } = STOCK_TYPE

Component({
  mixins: [ methods ],
  data: {
    EQUITY_TYPE,
    CREDITS_TYPE,
    OBJECT_TYPE,
    LOWER_TYPE,
    SIMPLE_EQUITY,
    MEMBER_EQUITY,
    STOCK_LIMIT,
    STOCK_NO_LIMIT,
    originData: [],
    formData: {},
    formState: {}
  },
  props: {
    prizeDialogData: {
      index: "",
      record: {},
    },
    maxRankLimit: "", // 限制最高排名
    type: "", // 奖品弹窗类型  probability: 概率  rank: 排名
    activityOutId: "",
    isEdit: false,
    visible: false,
    hasEditPrize: false,
    datasource: [],
    prizeDataType: null,
    conditionKeys: [],
    dialogForm: [],
    onClose: function () { },
    onUpdate: function () { },
    onAdd: function () { }
  },
  onInit() {
    const { dialogForm } = this.props
    const { formData, formState } = getFormInfo(dialogForm)
    this.setData({
      formData,
      formState,
      originData: cloneForce(dialogForm)
    })
  },
  didMount() {
    this.resetPrizeInit();
    this.initBenefit();
  },
  methods: {
    onCloseDialog() {
      this.props.onClose && this.props.onClose();
    },
    initBenefit() {
      const that = this;
      const bridge = {
        bizCode, // 此处输入想配置的商家应用appID
        // 这个方法用于获取插件中用户选择的奖池enname
        async getCheckBenefitID({ ename, poolID }) {
          my.showToast({
            type: "success",
            content: "已选择权益奖品",
          });
          const { success, data, message } = await queryBenefitByEname({
            ename,
          });
          const {
            benefitName,
            startTime,
            endTime,
            stock,
            amount
          } = data[0];
          if (success) {
            // 切换不同优惠券内容置空
            if (ename == that.data.formData.ename) {
              that.setData({
                formData: {
                  ...that.data.formData,
                  name: benefitName,
                  type: EQUITY_TYPE,
                  startTime,
                  endTime,
                  stock: stock,
                  amount
                },
              });
            } else {
              that.setData({
                formData: {
                  ...that.data.formData,
                  name: benefitName,
                  type: EQUITY_TYPE,
                  startTime,
                  _id: null,
                  endTime,
                  stock: "",
                  useStock: 0,
                  switchStock: 2,
                  amount: 0
                },
              });
            }
            // 先去判断优惠券是否更换,再赋值ename
            that.setData({
              formData: {
                ...that.data.formData,
                ename,
              },
            });
            that.$page.data.backPageTimeOut = setTimeout(() => {
              my.navigateBack({
                delta: 1,
              });
            }, 6000);
          } else {
            my.showToast({
              type: "fail",
              content: message,
            });
          }
        },
      };
      plugin.setBridge(bridge);
    },
    // 编辑更换类型时重置数据
    resetPrizeInit() {
      const { isEdit, prizeDialogData } = this.props;
      if (isEdit) {
        const { ...rest } = prizeDialogData.record;
        const parsingData = parsingFormData(rest)
        this.setData({
          formData: {
            ...this.data.formData,
            ...parsingData
          },
        });
      }
    },
    // 重置库存
    resetStock(value, name) {
      if (name === 'switchStock' && value === 2) {
        this.setData({
          formData: {
            ...this.data.formData,
            stock: ''
          }
        })
      }
    },
    navigateToPlugin() {
      clearTimeout(this.$page.data.backPageTimeOut);
      my.navigateTo({
        url: "plugin://myPlugin/orightindex-page",
      });
    },
    // 更新奖品
    updatePrize() {
      const isValidForm = this.validateForm();
      if (!isValidForm) return;

      const { formData } = this.data;
      const { prizeDialogData, prizeDataType, onUpdate, onAdd, conditionKeys, isEdit } = this.props

      const formatData = formatFormData(formData)
      let prizeData = {
        ...formatData,
        stock: formatData.stock ? +formatData.stock : 0,
        credits: formatData.credits ? +formatData.credits : 0,
        useStock: formatData.useStock ? +formatData.useStock : 0,
        prizeDataType: +prizeDataType
      }
      // 自定义新增字段
      if (conditionKeys && conditionKeys.length) {
        const conditions = {};
        conditionKeys.forEach(item => {
          conditions[item.key] = +item.value;
        });
        prizeData = {
          ...prizeData,
          ...conditions
        };
      }
      if (isEdit) {
        onUpdate && onUpdate(prizeData, prizeDialogData.index);
      } else {
        onAdd && onAdd(prizeData);
      }
      this.onCloseDialog();
    }
  },
});
