import { getStats } from "/api";
import dayjs from "dayjs";

Component({
  mixins: [],
  data: {
    // 搜索条件
    searchInfo: {
      timeRange: [] // 发奖时间
    },
    titleList: [],
    list: [],
    isLoading: false,
    winactivityId: ""
  },
  props: {
    onClose: () => {},
    selectedItem: {}
  },
  didMount() {
    const now = new Date();
    const today = dayjs(now).format("YYYY/MM/DD");
    const startTime = today.slice(0, 8) + "01";
    this.setData({
      "searchInfo.timeRange": [startTime, today]
    });
    this.searchList();
  },
  didUpdate() {},
  didUnmount() {},
  methods: {
    async searchList() {
      this.setData({
        isLoading: true,
        list: []
      });
      const startDay = this.data.searchInfo.timeRange[0].replace(/-/g, "/");
      const endDay = this.data.searchInfo.timeRange[1].replace(/-/g, "/");
      const params = {
        activityId: this.props.selectedItem.activityId,
        startDay,
        endDay
      };

      const { data } = (await getStats(params)) || {};
      // console.log("data::::::::", data);
      const { xlsxData } = data;
      const titleList = xlsxData[0];
      const dataList = xlsxData.slice(1);

      let tableData = [];
      dataList.forEach((item, idx) => {
        let itemObj = {};
        titleList.forEach((it, i) => {
          itemObj[it] = item[i];
        });
        tableData.push(itemObj);
      });
      console.log("tableData::::::::", tableData);
      if (tableData && tableData.length > 0) {
        this.setData({
          isLoading: false,
          titleList,
          list: tableData
        });
      }
    },
    // 监听发奖时间变化
    handleTimeRangeChange(e) {
      const [startTime, endTime] = e.detail.value;
      this.setData({
        "searchInfo.timeRange": [startTime, endTime]
      });
    },
    onCloseDialog() {
      this.props.onClose && this.props.onClose();
    }
  }
});
