"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.saveParams = void 0;
var constants_1 = require("../constants");
exports.saveParams = {
    title: {
        required: true,
        type: 'string',
        validator: function (rule, value, cb, source) {
            value = value.trim();
            if (!value)
                return new Error('活动名称为空');
            if (value.length > 12)
                return new Error('活动名称不可超过12个字');
            return cb();
        }
    },
    rule: {
        required: true,
        message: '活动规则不可为空'
    },
    startTime: {
        required: true,
        validator: function (rule, value, cb, source) {
            var endTime = source.endTime, activityId = source.activityId;
            if (!value)
                return new Error('请配置活动开始时间');
            if (value > endTime)
                return new Error('开始时间不得大于结束时间');
            if (!activityId && value < Date.now())
                return new Error('新建活动开始时间需小于当前时间');
            return cb();
        }
    },
    endTime: {
        required: true,
        validator: function (rule, value, cb, source) {
            if (!value)
                return new Error('请配置活动结束时间');
            return cb();
        }
    },
    tasks: {
        required: true,
        validator: function (rule, tasks, cb, source) {
            var taskList = Object.keys(tasks).map(function (type) {
                return __assign(__assign({}, tasks[type]), { type: type });
            });
            if (taskList.length === 0)
                return new Error('任务配置必须配置一项');
            var canPassTask = { status: true, message: '' };
            taskList.forEach(function (i) {
                if (!i.type) {
                    canPassTask = {
                        status: false,
                        message: '任务必须配置'
                    };
                }
                if (constants_1.TASK_CHECK_TYPE.link.list.includes(i.type)) {
                    if (canPassTask.status) {
                        canPassTask = urlCheck(i.link, constants_1.PASS_URL_LIST);
                    }
                }
                if (constants_1.TASK_CHECK_TYPE.itemIds.list.includes(i.type)) {
                    if (!i.itemIds) {
                        canPassTask = {
                            status: false,
                            message: constants_1.TASK_TYPE_TEXT[i.type] + '必须配置'
                        };
                    }
                }
                if (constants_1.TASK_CHECK_TYPE.value.list.includes(i.type)) {
                    if (!i.value) {
                        canPassTask = {
                            status: false,
                            message: constants_1.TASK_TYPE_TEXT[i.type] + '任务值必须配置'
                        };
                    }
                    if (!constants_1.TASK_CHECK_TYPE.value.reg.test(i.value)) {
                        canPassTask = {
                            status: false,
                            message: constants_1.TASK_TYPE_TEXT[i.type] + '任务值在' + constants_1.TASK_CHECK_TYPE.value.regName
                        };
                    }
                }
                if (constants_1.TASK_CHECK_TYPE.times.list.includes(i.type)) {
                    if (!i.times) {
                        canPassTask = {
                            status: false,
                            message: constants_1.TASK_TYPE_TEXT[i.type] + '任务次数必须配置'
                        };
                    }
                }
                if (constants_1.TASK_CHECK_TYPE.title.list.includes(i.type)) {
                    if (!i.title) {
                        canPassTask = {
                            status: false,
                            message: constants_1.TASK_TYPE_TEXT[i.type] + '任务标题必须配置'
                        };
                    }
                }
                if (constants_1.TASK_CHECK_TYPE.taskRateType.list.includes(i.type)) {
                    if (!i.taskRateType) {
                        canPassTask = {
                            status: false,
                            message: constants_1.TASK_TYPE_TEXT[i.type] + '任务类型必须配置'
                        };
                    }
                }
                i.value = +i.value;
                i.times = +i.times || '';
                i.taskRateType = +i.taskRateType || '';
                return i;
            });
            if (!canPassTask.status)
                return new Error(canPassTask.message);
            return cb();
        }
    }
};
var urlCheck = function (link, passUrlList) {
    if (!link.startsWith('http://') && !link.startsWith('https://')) {
        return { status: false, message: '页面链接必须以https://或http://开头' };
    }
    var passUrl = false;
    passUrlList.some(function (i) {
        if (~link.indexOf(i)) {
            passUrl = true;
            return true;
        }
        return false;
    });
    if (!passUrl)
        return {
            status: false,
            message: '域名校验不通过'
        };
    return {
        status: true,
        message: ''
    };
};
//# sourceMappingURL=saveValidate.js.map