/** @format */
import { UserService, AccessService } from '../service';
interface IVipContext extends Context {
    data: {
        activityId: string;
        callbackUrl?: string;
    };
}
interface ILoginContext extends Context {
    data: {
        activityId: string;
        userNick: string;
        avatar: string;
        isFollow: boolean;
        inviteId?: string;
    };
}
export default class User {
    /**
     *  登录接口, 初始化/更新用户信息
     */
    login(context: ILoginContext, { userInfo, vipInfo, activityInfo }: IControllerInfos, [userService, accessService]: [UserService, AccessService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result>;
    /**
     *  获取会员信息
     */
    getVipInfo(context: IVipContext, { session }: IControllerInfos, [userService]: [UserService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result>;
}
export {};
