import { TASK_RATE_TYPE } from '../const'
import flatten from 'lodash/flatten'
import { rankTableValidator } from "../../../utils/validate";

// 使用 async-validator 校验
// 文档地址: https://github.com/yiminghe/async-validator
export const descriptor = {
  title: {
    required: true,
    validator: (rule, value) => !!value && value.length <= 12,
    message: "请输入正确的活动名称"
  },
  subtitle: {
    required: true,
    validator: (rule, value) => !!value && value.length <= 16,
    message: "请输入正确的活动副标题"
  },
  prizeInfoList: {
    required: true,
    validator: rankTableValidator
  },
  timeRange: {
    required: true
  },
  rule: {
    required: true,
    message: '请输入活动规则'
  },
  taskMap: {
    type: 'object',
    required: true,
    fields: {
      collectGoods: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请输入收藏商品任务'
      },
      browseGoods: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请输入浏览商品任务'
      }
    }
  }
};



export const formatValidator = (descriptor, validators) => {
  validators = validators || {}
  Object.keys(descriptor).forEach(key => {
    if(descriptor[key].fields) {
      Object.keys(descriptor[key].fields).forEach(fieldKey => {
        validators[`${key}.${fieldKey}`] = {
          status: 'success',
          message: ''
        }
      })
    } else {
      validators[key] = {
        status: 'success',
        message: ''
      }
    }
    
  });
  return validators
}