
import dayjs from 'dayjs';
import { getMillSeconsByDays } from '../../../cmpUtils/time';
Component({
  mixins: [],
  data: {
    innerTimeRange: [],
    state: '',
    errorTips: ''
  },
  props: {
    timeRange: [],
    // 用于活动开始后,不可更改开始时间的备份
    originalStartTime: '',
    disabled: false,
    onChange: () => {},
    disableStartTime: false
  },
  didMount() {
    this.initTime();
  },
  didUpdate(prevProps) {
    this.changeTime(prevProps, this.props)
  },
  didUnmount() {},
  methods: {
    
    // 初始化时间, 默认开始时间为当前时间后的10分钟  结束时间为7天之后
    initTime() {
      const { timeRange } = this.props;
      const nowTime = new Date().getTime();
      const sevenDays = getMillSeconsByDays(7);
      const tenMinutes = 600000;
      let defaultStartTime = timeRange[0];
      let defaultEndTime = timeRange[1];

      // 当前时间 + 10分钟
      let startNow = dayjs(nowTime + tenMinutes).format("YYYY-MM-DD HH:mm:ss");
      // 开始时间 + 7天
      let endNow = dayjs(nowTime + tenMinutes + sevenDays).format("YYYY-MM-DD HH:mm:ss");

      // 配置了初始时间,则使用初始时间
      if(defaultStartTime) {
        startNow = defaultStartTime;
      }
      defaultEndTime && (endNow = defaultEndTime);

      this.setData({
        innerTimeRange: [ startNow, endNow ]
      })
      this.confrimChangeTime([new Date(startNow).getTime(), new Date(endNow).getTime()])
    },
    // defaultStartTime, defaultEndTime props变化
    changeTime(prevProps, currentProps) {
      let prevStartTime = prevProps.timeRange[0];
      let currentStartTime = currentProps.timeRange[0];
      let prevEndTime = prevProps.timeRange[1];
      let currentEndTime = currentProps.timeRange[1];

      const isTimeChange = currentStartTime !== prevStartTime 
      || currentEndTime !== prevEndTime;
      if(isTimeChange) {
        this.setData({
          innerTimeRange: [ 
            dayjs(currentStartTime).format("YYYY-MM-DD HH:mm:ss"),
            dayjs(currentEndTime).format("YYYY-MM-DD HH:mm:ss")
          ]
        })
      }
    },
    pickerChange(e) {
      const [startTime, endTime] = e.detail.value;
      const innerTimeRange = [ startTime || '', endTime || '' ];
      if(!startTime && !endTime) {
        this.confrimChangeTime(['', ''])
      }
      this.setData({
        innerTimeRange
      })

    },
     // 确认时间
    checkoutTime(startTime, endTime) {

      const { disableStartTime, originalStartTime } = this.props;
      const isStart = originalStartTime < Date.now();
      
      // 编辑活动时,如果活动已经开始, 开始时间不能编辑
      if (disableStartTime && isStart) {
        this.confrimChangeTime([dayjs(originalStartTime).format("YYYY-MM-DD HH:mm:ss"), endTime])
        startTime = originalStartTime
      }
      let timeHasSame = new Date(endTime).getTime() === new Date(startTime).getTime()
      let timeIsCantChoose = new Date().getTime() > new Date(startTime).getTime()


      if (timeHasSame || timeIsCantChoose) {
        let errTips = '';
        if (timeIsCantChoose && !disableStartTime) {
          errTips = `活动开始时间不能小于当前时间`
          console.log('error', '活动开始时间不能小于当前时间')
        }
        if (timeHasSame) {
          errTips = `开始时间不能等于结束时间`
          console.log('error', '开始时间不能等于结束时间')
        }
        this.confrimChangeTime([startTime, endTime], errTips)
      } else {
        this.setData({
          state: '',
          errorTips: ''
        })
        this.confrimChangeTime([startTime, endTime])
      }
    },
    // 时间选择框状态变化
    dialogChange(e) {
      const [startTime, endTime] = e.target.dataset.time
      const {
        value
      } = e.detail
      if (!value) {
        this.checkoutTime(startTime, endTime)
      }
    },
    confrimChangeTime([startTime, endTime], error) {
      this.props.onChange && this.props.onChange([ new Date(startTime).getTime() || '', new Date(endTime).getTime() || ''], error);
    }
  }
});
