const { passUrlList } = require('../../../cmpUtils/const');

Component({
  mixins: [],
  data: {
    dataSource:[
      { label: 1, value: 1 },
      { label: 2, value: 2 },
      { label: 3, value: 3 },
      { label: 4, value: 4 },
      { label: 5, value:5 },
      { label: 6, value:6 },
      { label: 7, value:7 },
      { label: 8, value:8 },
      { label: 9, value:9 },
      { label: 10, value:10 },
    ],
      taskRateType: 1,
      times: '',
      title: '',
      link: '',
      itemIds: '',
      value: ''
  },
  props: {
    visible: false,
    hasLink: false,
    hasItems: false,
    type: '',
    unit: '',
    taskData: {
      title: '',
      taskRateType: 1,
      times: '',
      value: '',
      itemIds: ''
    },
    onClose: () => {},
    onUpdate: () => {}
  },
  didMount() {
    this.initData();
  },
  didUpdate() {},
  didUnmount() {},
  methods: {
    initData() {
      Object.keys(this.props.taskData).forEach(key => {
        this.setData({
          [key]: this.props.taskData[key]
        })
      });
    },
    onCloseDialog() {
      this.props.onClose();
    },
    onTimesChange(e) {
      const { value } = e.detail;
      this.setData({
        times: value
      })
    },
    onItemIdsChange(ids) {
      this.setData({
        itemIds:ids
      })
    },
    onTaskRateTypeChange(e) {
      const { value } = e.detail;
      this.setData({
        taskRateType: value
      })
    },
    onChange(e) {
      const { value } = e.detail;
      const { name } = e.target.dataset;
      this.setData({
        [name]: value
      })
    },
    validateLink(link) {
      if(!link) return false;
      if(link.startsWith('http://') || link.startsWith('https://')) {
        return passUrlList.some(url => link.indexOf(url) !== -1);
      }
      return false;
    },
    onSaveTask() {
      const { title, link, value, taskRateType, times, itemIds } = this.data;
      if(!title) {
        my.showToast({
          type: 'fail',
          content: '请输入任务标题'
        })
        return;
      }

      if(this.props.hasLink && !this.validateLink(link)) {
        my.showToast({
          type: 'fail',
          content: '请输入正确的链接地址'
        })
        return;
      }


      if(this.props.hasItems && !itemIds) {
        my.showToast({
          type: 'fail',
          content: '请输入选择商品'
        })
        return;
      }

      if(!value || !Number.isInteger(+value)) {
        my.showToast({
          type: 'fail',
          content: '请输入正确的任务奖励'
        })
        return;
      }

      let taskData = { title, link, value, taskRateType, times, itemIds, type: this.props.type };
      

      this.props.onUpdate && this.props.onUpdate(taskData);

      this.onCloseDialog();
    }
  },
});
