import * as tb from './lib/tb';
import * as tbMock from './lib/tbMock';
import * as utils from './lib/utils';
import * as constants from './lib/constants';
import capi from './lib/capi';
import request from './lib/request';

const isH5 = 'undefined' !== typeof window;

// 如果为h5环境走mock数据
let _tb = {};
Object.entries(tb).forEach(([key, value]) => {
  _tb[key] = isH5 ? tbMock[key] : value;
});

export default {
  capi,
  tb: _tb,
  utils,
  request,
  constants
};